/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.datasource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.datageneration.FieldType;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.test.ESTestCase;

public class MultifieldAddonHandler
implements DataSourceHandler {
    private static final String PLACEHOLDER = "_reserved_multifield";
    private static final float DEFAULT_CHANCE_OF_CHILD_FIELD = 0.5f;
    private final Map<FieldType, List<FieldType>> subfieldTypes;
    private final float chanceOfChildField;
    private static final List<FieldType> STRING_TYPES = List.of(FieldType.TEXT, FieldType.KEYWORD, FieldType.MATCH_ONLY_TEXT, FieldType.WILDCARD);
    public static MultifieldAddonHandler STRING_TYPE_HANDLER = new MultifieldAddonHandler(STRING_TYPES.stream().collect(Collectors.toMap(t -> t, t -> STRING_TYPES.stream().filter(s -> s != t).toList())));

    public MultifieldAddonHandler(Map<FieldType, List<FieldType>> subfieldTypes, float chanceOfChildField) {
        this.subfieldTypes = subfieldTypes;
        this.chanceOfChildField = chanceOfChildField;
    }

    public MultifieldAddonHandler(Map<FieldType, List<FieldType>> subfieldTypes) {
        this(subfieldTypes, 0.5f);
    }

    @Override
    public DataSourceResponse.LeafMappingParametersGenerator handle(DataSourceRequest.LeafMappingParametersGenerator request) {
        if (request.fieldName().equals(PLACEHOLDER)) {
            return null;
        }
        FieldType parentType = FieldType.tryParse(request.fieldType());
        List<FieldType> childTypes = this.subfieldTypes.get((Object)parentType);
        if (childTypes == null) {
            return null;
        }
        return new DataSourceResponse.LeafMappingParametersGenerator(() -> {
            assert (parentType != null);
            Map<String, Object> parent = MultifieldAddonHandler.getMappingForType(parentType, request);
            if (ESTestCase.randomFloat() > this.chanceOfChildField) {
                return parent;
            }
            FieldType childType = (FieldType)((Object)((Object)ESTestCase.randomFrom(childTypes)));
            Map<String, Object> child = MultifieldAddonHandler.getChildMappingForType(childType, request);
            child.put("type", childType.toString());
            String childName = "subfield_" + String.valueOf((Object)childType);
            parent.put("fields", Map.of(childName, child));
            return parent;
        });
    }

    private static Map<String, Object> getChildMappingForType(FieldType type, DataSourceRequest.LeafMappingParametersGenerator request) {
        Map<String, Object> mapping = MultifieldAddonHandler.getMappingForType(type, request);
        mapping.remove("copy_to");
        return mapping;
    }

    private static Map<String, Object> getMappingForType(FieldType type, DataSourceRequest.LeafMappingParametersGenerator request) {
        return request.dataSource().get(new DataSourceRequest.LeafMappingParametersGenerator(request.dataSource(), PLACEHOLDER, type.toString(), request.eligibleCopyToFields(), request.dynamicMapping())).mappingGenerator().get();
    }
}

