/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class FieldCapsUtils
extends Enum<FieldCapsUtils> {
    private static final ConstructingObjectParser<FieldCapabilitiesFailure, Void> FAILURE_PARSER;
    private static final ConstructingObjectParser<FieldCapabilitiesResponse, Void> PARSER;
    private static final InstantiatingObjectParser<FieldCapabilities, String> FIELD_CAPS_PARSER;
    private static final /* synthetic */ FieldCapsUtils[] $VALUES;

    public static FieldCapsUtils[] values() {
        return (FieldCapsUtils[])$VALUES.clone();
    }

    public static FieldCapsUtils valueOf(String name) {
        return Enum.valueOf(FieldCapsUtils.class, name);
    }

    public static FieldCapabilitiesFailure parseFailure(XContentParser parser) throws IOException {
        return (FieldCapabilitiesFailure)FAILURE_PARSER.parse(parser, null);
    }

    public static FieldCapabilitiesResponse parseFieldCapsResponse(XContentParser parser) throws IOException {
        return (FieldCapabilitiesResponse)PARSER.parse(parser, null);
    }

    private static Map<String, FieldCapabilities> parseTypeToCapabilities(XContentParser parser, String name) throws IOException {
        XContentParser.Token token;
        HashMap<String, FieldCapabilities> typeToCapabilities = new HashMap<String, FieldCapabilities>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String type = parser.currentName();
            FieldCapabilities capabilities = FieldCapsUtils.parseFieldCaps(name, parser);
            typeToCapabilities.put(type, capabilities);
        }
        return typeToCapabilities;
    }

    public static FieldCapabilities parseFieldCaps(String name, XContentParser parser) throws IOException {
        return (FieldCapabilities)FIELD_CAPS_PARSER.parse(parser, (Object)name);
    }

    private static /* synthetic */ FieldCapsUtils[] $values() {
        return new FieldCapsUtils[0];
    }

    static {
        $VALUES = FieldCapsUtils.$values();
        FAILURE_PARSER = new ConstructingObjectParser("field_capabilities_failure", true, a -> new FieldCapabilitiesFailure((String[])((List)a[0]).toArray(String[]::new), (Exception)a[1]));
        FAILURE_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), FieldCapabilitiesFailure.INDICES_FIELD);
        FAILURE_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)p.currentToken(), (XContentParser)p);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)p.nextToken(), (XContentParser)p);
            ElasticsearchException e = ElasticsearchException.failureFromXContent((XContentParser)p);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
            return e;
        }, FieldCapabilitiesFailure.FAILURE_FIELD);
        PARSER = new ConstructingObjectParser("field_capabilities_response", true, a -> {
            Map<String, Map> responseMap = ((List)a[0]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            List indices = a[1] == null ? Collections.emptyList() : (List)a[1];
            List failures = a[2] == null ? Collections.emptyList() : (List)a[2];
            return FieldCapabilitiesResponse.builder().withIndices((String[])indices.toArray(String[]::new)).withFields(responseMap).withFailures(failures).build();
        });
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            Map<String, FieldCapabilities> typeToCapabilities = FieldCapsUtils.parseTypeToCapabilities(p, n);
            return new Tuple((Object)n, typeToCapabilities);
        }, FieldCapabilitiesResponse.FIELDS_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilitiesResponse.INDICES_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FieldCapsUtils.parseFailure(p), FieldCapabilitiesResponse.FAILURES_FIELD);
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"field_capabilities", (boolean)true, FieldCapabilities.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), FieldCapabilities.TYPE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.IS_METADATA_FIELD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), FieldCapabilities.SEARCHABLE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), FieldCapabilities.AGGREGATABLE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.TIME_SERIES_DIMENSION_FIELD);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.TIME_SERIES_METRIC_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.NON_SEARCHABLE_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.NON_AGGREGATABLE_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.NON_DIMENSION_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FieldCapabilities.METRIC_CONFLICTS_INDICES_FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> p.map(HashMap::new, v -> Set.copyOf(v.list())), new ParseField("meta", new String[0]));
        FIELD_CAPS_PARSER = parser.build();
    }
}

