/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.TimeSeriesParams;

public class FieldCapabilitiesBuilder {
    private final String name;
    private final String type;
    private boolean isMetadataField;
    private boolean isSearchable;
    private boolean isAggregatable;
    private boolean isDimension;
    @Nullable
    private TimeSeriesParams.MetricType metricType;
    @Nullable
    private String[] indices;
    @Nullable
    private String[] nonSearchableIndices;
    @Nullable
    private String[] nonAggregatableIndices;
    @Nullable
    private String[] nonDimensionIndices;
    @Nullable
    private String[] metricConflictsIndices;
    private Map<String, Set<String>> meta;

    public FieldCapabilitiesBuilder(String name, String type) {
        this.name = name;
        this.type = type;
        this.isSearchable = true;
        this.isAggregatable = true;
        this.meta = Collections.emptyMap();
    }

    public FieldCapabilitiesBuilder isMetadataField(boolean isMetadataField) {
        this.isMetadataField = isMetadataField;
        return this;
    }

    public FieldCapabilitiesBuilder isSearchable(boolean isSearchable) {
        this.isSearchable = isSearchable;
        return this;
    }

    public FieldCapabilitiesBuilder isAggregatable(boolean isAggregatable) {
        this.isAggregatable = isAggregatable;
        return this;
    }

    public FieldCapabilitiesBuilder isDimension(boolean isDimension) {
        this.isDimension = isDimension;
        return this;
    }

    public FieldCapabilitiesBuilder metricType(TimeSeriesParams.MetricType metricType) {
        this.metricType = metricType;
        return this;
    }

    public FieldCapabilitiesBuilder indices(String ... indices) {
        this.indices = FieldCapabilitiesBuilder.copyStringArray(indices);
        return this;
    }

    public FieldCapabilitiesBuilder nonSearchableIndices(String ... nonSearchableIndices) {
        this.nonSearchableIndices = FieldCapabilitiesBuilder.copyStringArray(nonSearchableIndices);
        return this;
    }

    public FieldCapabilitiesBuilder nonAggregatableIndices(String ... nonAggregatableIndices) {
        this.nonAggregatableIndices = FieldCapabilitiesBuilder.copyStringArray(nonAggregatableIndices);
        return this;
    }

    public FieldCapabilitiesBuilder nonDimensionIndices(String ... nonDimensionIndices) {
        this.nonDimensionIndices = FieldCapabilitiesBuilder.copyStringArray(nonDimensionIndices);
        return this;
    }

    public FieldCapabilitiesBuilder metricConflictsIndices(String ... metricConflictsIndices) {
        this.metricConflictsIndices = FieldCapabilitiesBuilder.copyStringArray(metricConflictsIndices);
        return this;
    }

    private static String[] copyStringArray(@Nullable String[] strings) {
        return strings != null ? Arrays.copyOf(strings, strings.length) : null;
    }

    public FieldCapabilitiesBuilder meta(Map<String, Set<String>> meta) {
        this.meta = meta != null ? new TreeMap<String, Set<String>>(meta) : null;
        return this;
    }

    public FieldCapabilities build() {
        return new FieldCapabilities(this.name, this.type, this.isMetadataField, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, this.indices, this.nonSearchableIndices, this.nonAggregatableIndices, this.nonDimensionIndices, this.metricConflictsIndices, this.meta);
    }
}

