/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.StreamsGroupMemberAssignment;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class StreamsGroupMemberDescription {
    private final String memberId;
    private final int memberEpoch;
    private final Optional<String> instanceId;
    private final Optional<String> rackId;
    private final String clientId;
    private final String clientHost;
    private final int topologyEpoch;
    private final String processId;
    private final Optional<Endpoint> userEndpoint;
    private final Map<String, String> clientTags;
    private final List<TaskOffset> taskOffsets;
    private final List<TaskOffset> taskEndOffsets;
    private final StreamsGroupMemberAssignment assignment;
    private final StreamsGroupMemberAssignment targetAssignment;
    private final boolean isClassic;

    public StreamsGroupMemberDescription(String memberId, int memberEpoch, Optional<String> instanceId, Optional<String> rackId, String clientId, String clientHost, int topologyEpoch, String processId, Optional<Endpoint> userEndpoint, Map<String, String> clientTags, List<TaskOffset> taskOffsets, List<TaskOffset> taskEndOffsets, StreamsGroupMemberAssignment assignment, StreamsGroupMemberAssignment targetAssignment, boolean isClassic) {
        this.memberId = Objects.requireNonNull(memberId);
        this.memberEpoch = memberEpoch;
        this.instanceId = Objects.requireNonNull(instanceId);
        this.rackId = Objects.requireNonNull(rackId);
        this.clientId = Objects.requireNonNull(clientId);
        this.clientHost = Objects.requireNonNull(clientHost);
        this.topologyEpoch = topologyEpoch;
        this.processId = Objects.requireNonNull(processId);
        this.userEndpoint = Objects.requireNonNull(userEndpoint);
        this.clientTags = Objects.requireNonNull(clientTags);
        this.taskOffsets = Objects.requireNonNull(taskOffsets);
        this.taskEndOffsets = Objects.requireNonNull(taskEndOffsets);
        this.assignment = Objects.requireNonNull(assignment);
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        this.isClassic = isClassic;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public Optional<String> instanceId() {
        return this.instanceId;
    }

    public Optional<String> rackId() {
        return this.rackId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public int topologyEpoch() {
        return this.topologyEpoch;
    }

    public String processId() {
        return this.processId;
    }

    public Optional<Endpoint> userEndpoint() {
        return this.userEndpoint;
    }

    public Map<String, String> clientTags() {
        return Map.copyOf(this.clientTags);
    }

    public List<TaskOffset> taskOffsets() {
        return List.copyOf(this.taskOffsets);
    }

    public List<TaskOffset> taskEndOffsets() {
        return List.copyOf(this.taskEndOffsets);
    }

    public StreamsGroupMemberAssignment assignment() {
        return this.assignment;
    }

    public StreamsGroupMemberAssignment targetAssignment() {
        return this.targetAssignment;
    }

    public boolean isClassic() {
        return this.isClassic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsGroupMemberDescription that = (StreamsGroupMemberDescription)o;
        return this.memberEpoch == that.memberEpoch && this.topologyEpoch == that.topologyEpoch && this.isClassic == that.isClassic && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.rackId, that.rackId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientHost, that.clientHost) && Objects.equals(this.processId, that.processId) && Objects.equals(this.userEndpoint, that.userEndpoint) && Objects.equals(this.clientTags, that.clientTags) && Objects.equals(this.taskOffsets, that.taskOffsets) && Objects.equals(this.taskEndOffsets, that.taskEndOffsets) && Objects.equals(this.assignment, that.assignment) && Objects.equals(this.targetAssignment, that.targetAssignment);
    }

    public int hashCode() {
        return Objects.hash(this.memberId, this.memberEpoch, this.instanceId, this.rackId, this.clientId, this.clientHost, this.topologyEpoch, this.processId, this.userEndpoint, this.clientTags, this.taskOffsets, this.taskEndOffsets, this.assignment, this.targetAssignment, this.isClassic);
    }

    public String toString() {
        return "(memberId=" + this.memberId + ", memberEpoch=" + this.memberEpoch + ", instanceId=" + this.instanceId.orElse("null") + ", rackId=" + this.rackId.orElse("null") + ", clientId=" + this.clientId + ", clientHost=" + this.clientHost + ", topologyEpoch=" + this.topologyEpoch + ", processId=" + this.processId + ", userEndpoint=" + this.userEndpoint.map(Endpoint::toString).orElse("null") + ", clientTags=" + String.valueOf(this.clientTags) + ", taskOffsets=" + this.taskOffsets.stream().map(TaskOffset::toString).collect(Collectors.joining(",")) + ", taskEndOffsets=" + this.taskEndOffsets.stream().map(TaskOffset::toString).collect(Collectors.joining(",")) + ", assignment=" + String.valueOf(this.assignment) + ", targetAssignment=" + String.valueOf(this.targetAssignment) + ", isClassic=" + this.isClassic + ")";
    }

    public static class TaskOffset {
        private final String subtopologyId;
        private final int partition;
        private final long offset;

        public TaskOffset(String subtopologyId, int partition, long offset) {
            this.subtopologyId = Objects.requireNonNull(subtopologyId);
            this.partition = partition;
            this.offset = offset;
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public int partition() {
            return this.partition;
        }

        public long offset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskOffset that = (TaskOffset)o;
            return this.partition == that.partition && this.offset == that.offset && Objects.equals(this.subtopologyId, that.subtopologyId);
        }

        public int hashCode() {
            return Objects.hash(this.subtopologyId, this.partition, this.offset);
        }

        public String toString() {
            return this.subtopologyId + "_" + this.partition + "=" + this.offset;
        }
    }

    public static class Endpoint {
        private final String host;
        private final int port;

        public Endpoint(String host, int port) {
            this.host = Objects.requireNonNull(host);
            this.port = port;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Endpoint endpoint = (Endpoint)o;
            return this.port == endpoint.port && Objects.equals(this.host, endpoint.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }

        public String toString() {
            return "(host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

