/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.exporter;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;

public abstract class MonitoringDoc
implements ToXContentObject {
    private static final DateFormatter dateTimeFormatter = DateFormatter.forPattern("strict_date_time").withZone(ZoneOffset.UTC);
    private final String cluster;
    private final long timestamp;
    private final long intervalMillis;
    private final Node node;
    private final MonitoredSystem system;
    private final String type;
    private final String id;

    public MonitoringDoc(String cluster, long timestamp, long intervalMillis, @Nullable Node node, MonitoredSystem system, String type, @Nullable String id) {
        this.cluster = Objects.requireNonNull(cluster);
        this.timestamp = timestamp;
        this.intervalMillis = intervalMillis;
        this.node = node;
        this.system = Objects.requireNonNull(system);
        this.type = Objects.requireNonNull(type);
        this.id = id;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public Node getNode() {
        return this.node;
    }

    public MonitoredSystem getSystem() {
        return this.system;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringDoc that = (MonitoringDoc)o;
        return this.timestamp == that.timestamp && this.intervalMillis == that.intervalMillis && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.node, that.node) && this.system == that.system && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cluster, this.timestamp, this.intervalMillis, this.node, this.system, this.type, this.id});
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("cluster_uuid", this.cluster);
        builder.field("timestamp", MonitoringDoc.toUTC(this.timestamp));
        builder.field("interval_ms", this.intervalMillis);
        builder.field("type", this.type);
        builder.field("source_node", this.node);
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    protected abstract void innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public static String toUTC(long timestamp) {
        return dateTimeFormatter.formatMillis(timestamp);
    }

    public static class Node
    implements Writeable,
    ToXContentObject {
        private final String uuid;
        private final String host;
        private final String transportAddress;
        private final String ip;
        private final String name;
        private final long timestamp;

        public Node(String uuid, String host, String transportAddress, String ip, String name, long timestamp) {
            this.uuid = uuid;
            this.host = host;
            this.transportAddress = transportAddress;
            this.ip = ip;
            this.name = name;
            this.timestamp = timestamp;
        }

        public Node(StreamInput in) throws IOException {
            this.uuid = in.readOptionalString();
            this.host = in.readOptionalString();
            this.transportAddress = in.readOptionalString();
            this.ip = in.readOptionalString();
            this.name = in.readOptionalString();
            this.timestamp = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.uuid);
            out.writeOptionalString(this.host);
            out.writeOptionalString(this.transportAddress);
            out.writeOptionalString(this.ip);
            out.writeOptionalString(this.name);
            out.writeVLong(this.timestamp);
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getHost() {
            return this.host;
        }

        public String getTransportAddress() {
            return this.transportAddress;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("uuid", this.uuid);
            builder.field("host", this.host);
            builder.field("transport_address", this.transportAddress);
            builder.field("ip", this.ip);
            builder.field("name", this.name);
            builder.field("timestamp", MonitoringDoc.toUTC(this.timestamp));
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.uuid, node.uuid) && Objects.equals(this.host, node.host) && Objects.equals(this.transportAddress, node.transportAddress) && Objects.equals(this.ip, node.ip) && Objects.equals(this.name, node.name) && Objects.equals(this.timestamp, node.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.host, this.transportAddress, this.ip, this.name, this.timestamp);
        }
    }
}

