/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.AbstractTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BertTokenizationUpdate
extends AbstractTokenizationUpdate {
    public static final ParseField NAME = BertTokenization.NAME;
    public static final ConstructingObjectParser<BertTokenizationUpdate, Void> PARSER = new ConstructingObjectParser("bert_tokenization_update", a -> new BertTokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0]), (Integer)a[1]));

    public static BertTokenizationUpdate fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public BertTokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(truncate, span);
    }

    public BertTokenizationUpdate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (!(originalConfig instanceof BertTokenization)) {
            throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        Tokenization.validateSpanAndTruncate(this.getTruncate(), this.getSpan());
        if (this.isNoop()) {
            return originalConfig;
        }
        if (this.getTruncate() != null && !this.getTruncate().isInCompatibleWithSpan()) {
            return new BertTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), this.getTruncate(), null);
        }
        return new BertTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), Optional.ofNullable(this.getTruncate()).orElse(originalConfig.getTruncate()), Optional.ofNullable(this.getSpan()).orElse(originalConfig.getSpan()));
    }

    @Override
    public String getWriteableName() {
        return BertTokenization.NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return BertTokenization.NAME.getPreferredName();
    }

    static {
        BertTokenizationUpdate.declareCommonParserFields(PARSER);
    }
}

