/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

final class EmptySource
implements Source {
    private static final EnumMap<XContentType, EmptySource> values = new EnumMap(XContentType.class);
    private final XContentType type;
    private final BytesReference sourceRef;

    static EmptySource forType(XContentType type) {
        return values.get(type);
    }

    private EmptySource(XContentType type) {
        this.type = type;
        try {
            this.sourceRef = new BytesArray(BytesReference.toBytes(BytesReference.bytes(new XContentBuilder(type.xContent(), new BytesStreamOutput()).value(Map.of()))));
        }
        catch (IOException e) {
            throw new AssertionError("impossible", e);
        }
    }

    @Override
    public XContentType sourceContentType() {
        return this.type;
    }

    @Override
    public Map<String, Object> source() {
        return Map.of();
    }

    @Override
    public BytesReference internalSourceRef() {
        return this.sourceRef;
    }

    @Override
    public Source filter(SourceFilter sourceFilter) {
        return this;
    }

    static {
        for (XContentType value : XContentType.values()) {
            values.put(value, new EmptySource(value));
        }
    }
}

