/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class RemoveProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove";
    private final List<TemplateScript.Factory> fieldsToRemove;
    private final List<TemplateScript.Factory> fieldsToKeep;
    private final boolean ignoreMissing;

    RemoveProcessor(String tag, String description, List<TemplateScript.Factory> fieldsToRemove, List<TemplateScript.Factory> fieldsToKeep, boolean ignoreMissing) {
        super(tag, description);
        this.fieldsToRemove = List.copyOf(fieldsToRemove);
        this.fieldsToKeep = List.copyOf(fieldsToKeep);
        this.ignoreMissing = ignoreMissing;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        if (!this.fieldsToKeep.isEmpty()) {
            this.fieldsToKeepProcessor(document);
        } else {
            this.fieldsToRemoveProcessor(document);
        }
        return document;
    }

    private void fieldsToRemoveProcessor(IngestDocument document) {
        for (TemplateScript.Factory field : this.fieldsToRemove) {
            document.removeField(document.renderTemplate(field), this.ignoreMissing);
        }
    }

    private void fieldsToKeepProcessor(IngestDocument document) {
        IngestDocument.getAllFields(document.getSourceAndMetadata()).stream().filter(documentField -> !IngestDocument.Metadata.isMetadata(documentField)).filter(documentField -> !RemoveProcessor.shouldKeep(documentField, this.fieldsToKeep, document)).forEach(documentField -> document.removeField((String)documentField, true));
    }

    static boolean shouldKeep(String documentField, List<TemplateScript.Factory> fieldsToKeep, IngestDocument document) {
        return fieldsToKeep.stream().anyMatch(fieldToKeep -> {
            String path = document.renderTemplate((TemplateScript.Factory)fieldToKeep);
            return documentField.equals(path) || path.startsWith(documentField + ".") || documentField.startsWith(path + ".");
        });
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public List<TemplateScript.Factory> getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    public List<TemplateScript.Factory> getFieldsToKeep() {
        return this.fieldsToKeep;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public RemoveProcessor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            List<TemplateScript.Factory> compiledTemplatesToRemove = this.getTemplates(tag, config, "field");
            List<TemplateScript.Factory> compiledTemplatesToKeep = this.getTemplates(tag, config, "keep");
            if (compiledTemplatesToRemove.isEmpty() && compiledTemplatesToKeep.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(RemoveProcessor.TYPE, tag, "keep", "or [field] must be specified");
            }
            if (!compiledTemplatesToRemove.isEmpty() && !compiledTemplatesToKeep.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(RemoveProcessor.TYPE, tag, "keep", "and [field] cannot both be used in the same processor");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(RemoveProcessor.TYPE, tag, config, "ignore_missing", false);
            return new RemoveProcessor(tag, description, compiledTemplatesToRemove, compiledTemplatesToKeep, ignoreMissing);
        }

        private List<TemplateScript.Factory> getTemplates(String processorTag, Map<String, Object> config, String propertyName) {
            return Factory.getFields(processorTag, config, propertyName).stream().map(f -> ConfigurationUtils.compileTemplate(RemoveProcessor.TYPE, processorTag, propertyName, f, this.scriptService)).toList();
        }

        private static List<String> getFields(String processorTag, Map<String, Object> config, String propertyName) {
            ArrayList<String> fields = new ArrayList<String>();
            if (!config.containsKey(propertyName)) {
                return fields;
            }
            Object field = ConfigurationUtils.readObject(RemoveProcessor.TYPE, processorTag, config, propertyName);
            if (field instanceof List) {
                List stringList = (List)field;
                fields.addAll(stringList);
            } else {
                fields.add((String)field);
            }
            return fields;
        }
    }
}

