/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.IndexSettings;

public final class MergePolicyConfig {
    private final TieredMergePolicy tieredMergePolicy = new TieredMergePolicy();
    private final LogByteSizeMergePolicy timeBasedMergePolicy = new LogByteSizeMergePolicy();
    private final Logger logger;
    private final boolean mergesEnabled;
    private volatile Type mergePolicyType;
    private final ByteSizeValue defaultMaxMergedSegment;
    private final ByteSizeValue defaultMaxTimeBasedMergedSegment;
    public static final double DEFAULT_EXPUNGE_DELETES_ALLOWED = 10.0;
    public static final ByteSizeValue DEFAULT_FLOOR_SEGMENT = ByteSizeValue.of(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 10;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = ByteSizeValue.of(5L, ByteSizeUnit.GB);
    public static final Setting<ByteSizeValue> DEFAULT_MAX_MERGED_SEGMENT_SETTING = Setting.byteSizeSetting("indices.merge.policy.max_merged_segment", DEFAULT_MAX_MERGED_SEGMENT, ByteSizeValue.ofBytes(1L), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final ByteSizeValue DEFAULT_MAX_TIME_BASED_MERGED_SEGMENT = ByteSizeValue.of(100L, ByteSizeUnit.GB);
    public static final Setting<ByteSizeValue> DEFAULT_MAX_TIME_BASED_MERGED_SEGMENT_SETTING = Setting.byteSizeSetting("indices.merge.policy.max_time_based_merged_segment", DEFAULT_MAX_TIME_BASED_MERGED_SEGMENT, ByteSizeValue.ofBytes(1L), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final double DEFAULT_SEGMENTS_PER_TIER = 10.0;
    public static final int DEFAULT_MERGE_FACTOR = 32;
    public static final double DEFAULT_DELETES_PCT_ALLOWED = 20.0;
    private static final String INDEX_COMPOUND_FORMAT_SETTING_KEY = "index.compound_format";
    public static final Setting<CompoundFileThreshold> INDEX_COMPOUND_FORMAT_SETTING = new Setting<CompoundFileThreshold>("index.compound_format", "1gb", MergePolicyConfig::parseCompoundFormat, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Type> INDEX_MERGE_POLICY_TYPE_SETTING = Setting.enumSetting(Type.class, "index.merge.policy.type", Type.UNSET, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING = Setting.doubleSetting("index.merge.policy.expunge_deletes_allowed", 10.0, 0.0, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.floor_segment", DEFAULT_FLOOR_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING = Setting.intSetting("index.merge.policy.max_merge_at_once", 10, 2, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING = Setting.intSetting("index.merge.policy.max_merge_at_once_explicit", 30, 2, Setting.Property.IndexSettingDeprecatedInV9AndRemovedInV10, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.max_merged_segment", ByteSizeValue.ZERO, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING = Setting.doubleSetting("index.merge.policy.segments_per_tier", 10.0, 2.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING = Setting.intSetting("index.merge.policy.merge_factor", 32, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING = Setting.doubleSetting("index.merge.policy.deletes_pct_allowed", 20.0, 5.0, 50.0, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final String INDEX_MERGE_ENABLED = "index.merge.enabled";

    MergePolicyConfig(Logger logger, IndexSettings indexSettings) {
        this.logger = logger;
        Type mergePolicyType = indexSettings.getValue(INDEX_MERGE_POLICY_TYPE_SETTING);
        double forceMergeDeletesPctAllowed = indexSettings.getValue(INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING);
        ByteSizeValue floorSegment = indexSettings.getValue(INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING);
        int maxMergeAtOnce = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING);
        this.defaultMaxMergedSegment = DEFAULT_MAX_MERGED_SEGMENT_SETTING.get(indexSettings.getNodeSettings());
        this.defaultMaxTimeBasedMergedSegment = DEFAULT_MAX_TIME_BASED_MERGED_SEGMENT_SETTING.get(indexSettings.getNodeSettings());
        ByteSizeValue maxMergedSegment = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING);
        double segmentsPerTier = indexSettings.getValue(INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING);
        int mergeFactor = indexSettings.getValue(INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING);
        double deletesPctAllowed = indexSettings.getValue(INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING);
        this.mergesEnabled = indexSettings.getSettings().getAsBoolean(INDEX_MERGE_ENABLED, true);
        if (!this.mergesEnabled) {
            logger.warn("[{}] is set to false, this should only be used in tests and can cause serious problems in production environments", (Object)INDEX_MERGE_ENABLED);
        }
        maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
        this.setMergePolicyType(mergePolicyType);
        this.setCompoundFormatThreshold(indexSettings.getValue(INDEX_COMPOUND_FORMAT_SETTING));
        this.setExpungeDeletesAllowed(forceMergeDeletesPctAllowed);
        this.setFloorSegmentSetting(floorSegment);
        this.setMaxMergesAtOnce(maxMergeAtOnce);
        this.setMaxMergedSegment(maxMergedSegment);
        this.setSegmentsPerTier(segmentsPerTier);
        this.setMergeFactor(mergeFactor);
        this.setDeletesPctAllowed(deletesPctAllowed);
        logger.trace("using merge policy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merged_segment[{}], segments_per_tier[{}], deletes_pct_allowed[{}]", (Object)forceMergeDeletesPctAllowed, (Object)floorSegment, (Object)maxMergeAtOnce, (Object)maxMergedSegment, (Object)segmentsPerTier, (Object)deletesPctAllowed);
    }

    void setMergePolicyType(Type type) {
        this.mergePolicyType = type;
    }

    void setSegmentsPerTier(double segmentsPerTier) {
        this.tieredMergePolicy.setSegmentsPerTier(segmentsPerTier);
    }

    void setMergeFactor(int mergeFactor) {
        this.timeBasedMergePolicy.setMergeFactor(mergeFactor);
    }

    void setMaxMergedSegment(ByteSizeValue maxMergedSegment) {
        if (maxMergedSegment.getBytes() == 0L) {
            this.tieredMergePolicy.setMaxMergedSegmentMB(this.defaultMaxMergedSegment.getMbFrac());
            this.timeBasedMergePolicy.setMaxMergeMB(this.defaultMaxTimeBasedMergedSegment.getMbFrac());
        } else {
            this.tieredMergePolicy.setMaxMergedSegmentMB(maxMergedSegment.getMbFrac());
            this.timeBasedMergePolicy.setMaxMergeMB(maxMergedSegment.getMbFrac());
        }
    }

    void setMaxMergesAtOnce(int maxMergeAtOnce) {
        this.tieredMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
    }

    void setFloorSegmentSetting(ByteSizeValue floorSegementSetting) {
        this.tieredMergePolicy.setFloorSegmentMB(floorSegementSetting.getMbFrac());
        this.timeBasedMergePolicy.setMinMergeMB(floorSegementSetting.getMbFrac());
    }

    void setExpungeDeletesAllowed(Double value) {
        this.tieredMergePolicy.setForceMergeDeletesPctAllowed(value);
    }

    void setCompoundFormatThreshold(CompoundFileThreshold compoundFileThreshold) {
        compoundFileThreshold.configure(this.tieredMergePolicy);
        compoundFileThreshold.configure(this.timeBasedMergePolicy);
    }

    void setDeletesPctAllowed(Double deletesPctAllowed) {
        this.tieredMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
    }

    private int adjustMaxMergeAtOnceIfNeeded(int maxMergeAtOnce, double segmentsPerTier) {
        if (segmentsPerTier < (double)maxMergeAtOnce) {
            int newMaxMergeAtOnce = (int)segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", (Object)maxMergeAtOnce, (Object)newMaxMergeAtOnce, (Object)segmentsPerTier);
            maxMergeAtOnce = newMaxMergeAtOnce;
        }
        return maxMergeAtOnce;
    }

    @SuppressForbidden(reason="we always use an appropriate merge scheduler alongside this policy so NoMergePolic#INSTANCE is ok")
    MergePolicy getMergePolicy(boolean isTimeBasedIndex) {
        if (!this.mergesEnabled) {
            return NoMergePolicy.INSTANCE;
        }
        return this.mergePolicyType.getMergePolicy(this, isTimeBasedIndex);
    }

    private static CompoundFileThreshold parseCompoundFormat(String noCFSRatio) {
        if ((noCFSRatio = noCFSRatio.trim()).equalsIgnoreCase("true")) {
            return new CompoundFileThreshold(1.0);
        }
        if (noCFSRatio.equalsIgnoreCase("false")) {
            return new CompoundFileThreshold(0.0);
        }
        try {
            try {
                return new CompoundFileThreshold(Double.parseDouble(noCFSRatio));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("index.compound_format must be a boolean, a non-negative byte size or a ratio in the interval [0..1] but was: [" + noCFSRatio + "]", ex);
            }
        }
        catch (IllegalArgumentException e) {
            try {
                return new CompoundFileThreshold(ByteSizeValue.parseBytesSizeValue(noCFSRatio, INDEX_COMPOUND_FORMAT_SETTING_KEY));
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }

    public static enum Type {
        UNSET{

            @Override
            MergePolicy getMergePolicy(MergePolicyConfig config, boolean isTimeBasedIndex) {
                if (isTimeBasedIndex) {
                    return config.timeBasedMergePolicy;
                }
                return config.tieredMergePolicy;
            }
        }
        ,
        TIERED{

            @Override
            MergePolicy getMergePolicy(MergePolicyConfig config, boolean isTimeBasedIndex) {
                return config.tieredMergePolicy;
            }
        }
        ,
        TIME_BASED{

            @Override
            MergePolicy getMergePolicy(MergePolicyConfig config, boolean isTimeBasedIndex) {
                return config.timeBasedMergePolicy;
            }
        };


        abstract MergePolicy getMergePolicy(MergePolicyConfig var1, boolean var2);
    }

    public static class CompoundFileThreshold {
        private Double noCFSRatio;
        private ByteSizeValue noCFSSize;

        private CompoundFileThreshold(double noCFSRatio) {
            if (noCFSRatio < 0.0 || noCFSRatio > 1.0) {
                throw new IllegalArgumentException("index.compound_format must be a boolean, a non-negative byte size or a ratio in the interval [0..1] but was: [" + noCFSRatio + "]");
            }
            this.noCFSRatio = noCFSRatio;
            this.noCFSSize = null;
        }

        private CompoundFileThreshold(ByteSizeValue noCFSSize) {
            if (noCFSSize.getBytes() < 0L) {
                throw new IllegalArgumentException("index.compound_format must be a boolean, a non-negative byte size or a ratio in the interval [0..1] but was: [" + String.valueOf(noCFSSize) + "]");
            }
            this.noCFSRatio = null;
            this.noCFSSize = noCFSSize;
        }

        void configure(MergePolicy mergePolicy) {
            if (this.noCFSRatio != null) {
                assert (this.noCFSSize == null);
                mergePolicy.setNoCFSRatio(this.noCFSRatio);
                mergePolicy.setMaxCFSSegmentSizeMB(Double.POSITIVE_INFINITY);
            } else {
                mergePolicy.setNoCFSRatio(1.0);
                mergePolicy.setMaxCFSSegmentSizeMB(this.noCFSSize.getMbFrac());
            }
        }

        public String toString() {
            if (this.noCFSRatio != null) {
                return "max CFS ratio: " + this.noCFSRatio;
            }
            return "max CFS size: " + String.valueOf(this.noCFSSize);
        }
    }
}

