/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Connection
implements JsonpSerializable {
    private final long docCount;
    private final long source;
    private final long target;
    private final double weight;
    public static final JsonpDeserializer<Connection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Connection::setupConnectionDeserializer);

    private Connection(Builder builder) {
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, (Object)this, "docCount", 0L);
        this.source = ApiTypeHelper.requireNonNull(builder.source, (Object)this, "source", 0L);
        this.target = ApiTypeHelper.requireNonNull(builder.target, (Object)this, "target", 0L);
        this.weight = ApiTypeHelper.requireNonNull(builder.weight, (Object)this, "weight", 0.0);
    }

    public static Connection of(Function<Builder, ObjectBuilder<Connection>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long docCount() {
        return this.docCount;
    }

    public final long source() {
        return this.source;
    }

    public final long target() {
        return this.target;
    }

    public final double weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("source");
        generator.write(this.source);
        generator.writeKey("target");
        generator.write(this.target);
        generator.writeKey("weight");
        generator.write(this.weight);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConnectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.add(Builder::source, JsonpDeserializer.longDeserializer(), "source");
        op.add(Builder::target, JsonpDeserializer.longDeserializer(), "target");
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Connection> {
        private Long docCount;
        private Long source;
        private Long target;
        private Double weight;

        public final Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        public final Builder source(long value) {
            this.source = value;
            return this;
        }

        public final Builder target(long value) {
            this.target = value;
            return this;
        }

        public final Builder weight(double value) {
            this.weight = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Connection build() {
            this._checkSingleUse();
            return new Connection(this);
        }
    }
}

