/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HoltLinearModelSettings
implements JsonpSerializable {
    @Nullable
    private final Float alpha;
    @Nullable
    private final Float beta;
    public static final JsonpDeserializer<HoltLinearModelSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HoltLinearModelSettings::setupHoltLinearModelSettingsDeserializer);

    private HoltLinearModelSettings(Builder builder) {
        this.alpha = builder.alpha;
        this.beta = builder.beta;
    }

    public static HoltLinearModelSettings of(Function<Builder, ObjectBuilder<HoltLinearModelSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float alpha() {
        return this.alpha;
    }

    @Nullable
    public final Float beta() {
        return this.beta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write(this.alpha.floatValue());
        }
        if (this.beta != null) {
            generator.writeKey("beta");
            generator.write(this.beta.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHoltLinearModelSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alpha, JsonpDeserializer.floatDeserializer(), "alpha");
        op.add(Builder::beta, JsonpDeserializer.floatDeserializer(), "beta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HoltLinearModelSettings> {
        @Nullable
        private Float alpha;
        @Nullable
        private Float beta;

        public final Builder alpha(@Nullable Float value) {
            this.alpha = value;
            return this;
        }

        public final Builder beta(@Nullable Float value) {
            this.beta = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HoltLinearModelSettings build() {
            this._checkSingleUse();
            return new HoltLinearModelSettings(this);
        }
    }
}

