/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.password;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.logstash.secret.password.DigitValidator;
import org.logstash.secret.password.EmptyStringValidator;
import org.logstash.secret.password.LengthValidator;
import org.logstash.secret.password.LowerCaseValidator;
import org.logstash.secret.password.PasswordParamConverter;
import org.logstash.secret.password.PasswordPolicyParam;
import org.logstash.secret.password.PasswordPolicyType;
import org.logstash.secret.password.SymbolValidator;
import org.logstash.secret.password.UpperCaseValidator;
import org.logstash.secret.password.Validator;

public class PasswordValidator {
    @VisibleForTesting
    protected List<Validator> validators = new ArrayList<Validator>();

    public PasswordValidator(Map<PasswordPolicyType, PasswordPolicyParam> policies) {
        policies.forEach((policy, param) -> {
            switch (policy) {
                case DIGIT: {
                    this.validators.add(new DigitValidator());
                    break;
                }
                case LENGTH: {
                    int minimumLength = param.getType().equals("MINIMUM_LENGTH") ? PasswordParamConverter.convert(Integer.class, param.getValue()) : 8;
                    this.validators.add(new LengthValidator(minimumLength));
                    break;
                }
                case SYMBOL: {
                    this.validators.add(new SymbolValidator());
                    break;
                }
                case LOWER_CASE: {
                    this.validators.add(new LowerCaseValidator());
                    break;
                }
                case UPPER_CASE: {
                    this.validators.add(new UpperCaseValidator());
                    break;
                }
                case EMPTY_STRING: {
                    this.validators.add(new EmptyStringValidator());
                }
            }
        });
    }

    public String validate(String password) {
        return this.validators.stream().map(validator -> validator.validate(password)).filter(Optional::isPresent).map(Optional::get).reduce("", (partialString, element) -> (String)(partialString.isEmpty() ? "" : partialString + ", ") + element);
    }
}

