/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class TimeSeriesFeatureSetUsage
extends XPackFeatureUsage {
    private static final TransportVersion TIME_SERIES_TELEMETRY = TransportVersion.fromName("time_series_telemetry");
    private final long timeSeriesDataStreamCount;
    private final long timeSeriesIndexCount;
    private final DownsamplingUsage downsamplingUsage;

    public TimeSeriesFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.timeSeriesDataStreamCount = input.readVLong();
        if (this.timeSeriesDataStreamCount == 0L) {
            this.timeSeriesIndexCount = 0L;
            this.downsamplingUsage = null;
        } else {
            this.timeSeriesIndexCount = input.readVLong();
            this.downsamplingUsage = input.readOptionalWriteable(DownsamplingUsage::read);
        }
    }

    public TimeSeriesFeatureSetUsage(long timeSeriesDataStreamCount, long timeSeriesIndexCount, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) {
        this(timeSeriesDataStreamCount, timeSeriesIndexCount, null, null, dlmDownsamplingStats, indexCountPerInterval);
    }

    public TimeSeriesFeatureSetUsage(long timeSeriesDataStreamCount, long timeSeriesIndexCount, DownsamplingFeatureStats ilmDownsamplingStats, Map<String, Long> phasesUsedInDownsampling, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) {
        super("time_series", true, true);
        this.timeSeriesDataStreamCount = timeSeriesDataStreamCount;
        if (timeSeriesDataStreamCount == 0L) {
            this.timeSeriesIndexCount = 0L;
            this.downsamplingUsage = null;
        } else {
            this.timeSeriesIndexCount = timeSeriesIndexCount;
            this.downsamplingUsage = new DownsamplingUsage(ilmDownsamplingStats, phasesUsedInDownsampling, dlmDownsamplingStats, indexCountPerInterval);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timeSeriesDataStreamCount);
        if (this.timeSeriesDataStreamCount > 0L) {
            out.writeVLong(this.timeSeriesIndexCount);
            out.writeOptionalWriteable(this.downsamplingUsage);
        }
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TIME_SERIES_TELEMETRY;
    }

    public long getTimeSeriesDataStreamCount() {
        return this.timeSeriesDataStreamCount;
    }

    public long getTimeSeriesIndexCount() {
        return this.timeSeriesIndexCount;
    }

    public DownsamplingUsage getDownsamplingUsage() {
        return this.downsamplingUsage;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("data_stream_count", this.timeSeriesDataStreamCount);
        if (this.timeSeriesDataStreamCount > 0L) {
            builder.field("index_count", this.timeSeriesIndexCount);
        }
        if (this.downsamplingUsage != null) {
            builder.field("downsampling", this.downsamplingUsage);
        }
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return Objects.hash(this.timeSeriesDataStreamCount, this.timeSeriesIndexCount, this.downsamplingUsage);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TimeSeriesFeatureSetUsage other = (TimeSeriesFeatureSetUsage)obj;
        return this.timeSeriesDataStreamCount == other.timeSeriesDataStreamCount && this.timeSeriesIndexCount == other.timeSeriesIndexCount && Objects.equals(this.downsamplingUsage, other.downsamplingUsage);
    }

    public record DownsamplingUsage(DownsamplingFeatureStats ilmDownsamplingStats, Map<String, Long> phasesUsedInDownsampling, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) implements Writeable,
    ToXContentObject
    {
        public static DownsamplingUsage read(StreamInput in) throws IOException {
            DownsamplingFeatureStats ilmDownsamplingStats = in.readOptionalWriteable(DownsamplingFeatureStats::read);
            Map<String, Long> phasesUsedInDownsampling = ilmDownsamplingStats != null ? in.readImmutableMap(StreamInput::readString, StreamInput::readVLong) : null;
            DownsamplingFeatureStats dlmDownsamplingStats = DownsamplingFeatureStats.read(in);
            Map<String, Long> indexCountPerInterval = in.readImmutableMap(StreamInput::readString, StreamInput::readVLong);
            return new DownsamplingUsage(ilmDownsamplingStats, phasesUsedInDownsampling, dlmDownsamplingStats, indexCountPerInterval);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable(this.ilmDownsamplingStats);
            if (this.ilmDownsamplingStats != null) {
                out.writeMap(this.phasesUsedInDownsampling, StreamOutput::writeString, StreamOutput::writeVLong);
            }
            this.dlmDownsamplingStats.writeTo(out);
            out.writeMap(this.indexCountPerInterval, StreamOutput::writeString, StreamOutput::writeVLong);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.indexCountPerInterval != null && !this.indexCountPerInterval.isEmpty()) {
                builder.startObject("index_count_per_interval");
                for (Map.Entry<String, Long> entry : this.indexCountPerInterval.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
                builder.endObject();
            }
            if (this.ilmDownsamplingStats != null) {
                builder.startObject("ilm");
                this.ilmDownsamplingStats.toXContent(builder, params);
                builder.field("phases_in_use", this.phasesUsedInDownsampling);
                builder.endObject();
            }
            if (this.dlmDownsamplingStats != null) {
                builder.startObject("dlm");
                this.dlmDownsamplingStats.toXContent(builder, params);
                builder.endObject();
            }
            return builder.endObject();
        }
    }

    public record DownsamplingFeatureStats(long dataStreamsCount, long indexCount, long minRounds, double averageRounds, long maxRounds) implements Writeable,
    ToXContentFragment
    {
        static final DownsamplingFeatureStats EMPTY = new DownsamplingFeatureStats(0L, 0L, 0L, 0.0, 0L);

        public static DownsamplingFeatureStats read(StreamInput in) throws IOException {
            long dataStreamsCount = in.readVLong();
            if (dataStreamsCount == 0L) {
                return EMPTY;
            }
            return new DownsamplingFeatureStats(dataStreamsCount, in.readVLong(), in.readVLong(), in.readDouble(), in.readVLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamsCount);
            if (this.dataStreamsCount != 0L) {
                out.writeVLong(this.indexCount);
                out.writeVLong(this.minRounds);
                out.writeDouble(this.averageRounds);
                out.writeVLong(this.maxRounds);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("downsampled_data_stream_count", this.dataStreamsCount);
            if (this.dataStreamsCount > 0L) {
                builder.field("downsampled_index_count", this.indexCount);
                builder.startObject("rounds_per_data_stream");
                builder.field("min", this.minRounds);
                builder.field("average", this.averageRounds);
                builder.field("max", this.maxRounds);
                builder.endObject();
            }
            return builder;
        }
    }
}

