/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Collection;
import java.util.List;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.AbstractLinkedProjectConfigService;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.RemoteClusterSettings;

public class ClusterSettingsLinkedProjectConfigService
extends AbstractLinkedProjectConfigService {
    private final Settings settings;
    private final ProjectResolver projectResolver;

    public ClusterSettingsLinkedProjectConfigService(Settings settings, @Nullable ClusterSettings clusterSettings, ProjectResolver projectResolver) {
        this.settings = settings;
        this.projectResolver = projectResolver;
        if (clusterSettings != null) {
            List<Setting.AffixSetting<?>> remoteClusterSettings = List.of(RemoteClusterSettings.REMOTE_CLUSTER_COMPRESS, RemoteClusterSettings.REMOTE_CLUSTER_PING_SCHEDULE, RemoteClusterSettings.REMOTE_CONNECTION_MODE, RemoteClusterSettings.SniffConnectionStrategySettings.REMOTE_CLUSTERS_PROXY, RemoteClusterSettings.SniffConnectionStrategySettings.REMOTE_CLUSTER_SEEDS, RemoteClusterSettings.SniffConnectionStrategySettings.REMOTE_NODE_CONNECTIONS, RemoteClusterSettings.ProxyConnectionStrategySettings.PROXY_ADDRESS, RemoteClusterSettings.ProxyConnectionStrategySettings.REMOTE_SOCKET_CONNECTIONS, RemoteClusterSettings.ProxyConnectionStrategySettings.SERVER_NAME);
            clusterSettings.addAffixGroupUpdateConsumer(remoteClusterSettings, this::settingsChangedCallback);
            clusterSettings.addAffixUpdateConsumer(RemoteClusterSettings.REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::skipUnavailableChangedCallback, (alias, value) -> {});
        }
    }

    @Override
    public Collection<LinkedProjectConfig> getInitialLinkedProjectConfigs() {
        return RemoteClusterSettings.getRemoteClusters(this.settings).stream().map(alias -> RemoteClusterSettings.toConfig(this.projectResolver.getProjectId(), ProjectId.DEFAULT, alias, this.settings)).toList();
    }

    private void settingsChangedCallback(String clusterAlias, Settings newSettings) {
        Settings mergedSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
        LinkedProjectConfig config = RemoteClusterSettings.toConfig(this.projectResolver.getProjectId(), ProjectId.DEFAULT, clusterAlias, mergedSettings);
        this.handleUpdate(config);
    }

    private void skipUnavailableChangedCallback(String clusterAlias, Boolean skipUnavailable) {
        this.handleSkipUnavailableChanged(this.projectResolver.getProjectId(), ProjectId.DEFAULT, clusterAlias, skipUnavailable);
    }
}

