/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logstashbridge.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.logstashbridge.StableBridgeAPI;
import org.elasticsearch.logstashbridge.ingest.IngestDocumentBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.script.ScriptServiceBridge;

public interface PipelineBridge
extends StableBridgeAPI<Pipeline> {
    public String getId();

    public void execute(IngestDocumentBridge var1, BiConsumer<IngestDocumentBridge, Exception> var2);

    public static PipelineBridge fromInternal(Pipeline pipeline) {
        return new ProxyInternal(pipeline);
    }

    public static PipelineBridge create(String id, Map<String, Object> config, Map<String, ProcessorFactoryBridge> processorFactories, ScriptServiceBridge scriptServiceBridge) throws Exception {
        return PipelineBridge.fromInternal(Pipeline.create(id, config, StableBridgeAPI.toInternal(processorFactories), StableBridgeAPI.toInternalNullable(scriptServiceBridge), ProjectId.DEFAULT));
    }

    public static class ProxyInternal
    extends StableBridgeAPI.ProxyInternal<Pipeline>
    implements PipelineBridge {
        ProxyInternal(Pipeline delegate) {
            super(delegate);
        }

        @Override
        public String getId() {
            return ((Pipeline)this.internalDelegate).getId();
        }

        @Override
        public void execute(IngestDocumentBridge ingestDocumentBridge, BiConsumer<IngestDocumentBridge, Exception> handler) {
            ((Pipeline)this.internalDelegate).execute(StableBridgeAPI.toInternalNullable(ingestDocumentBridge), (IngestDocument ingestDocument, Exception e) -> handler.accept(IngestDocumentBridge.fromInternalNullable(ingestDocument), (Exception)e));
        }
    }
}

