/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.core.Nullable;

public final class XMoreLikeThis {
    public static final int DEFAULT_MAX_NUM_TOKENS_PARSED = 5000;
    public static final int DEFAULT_MIN_TERM_FREQ = 2;
    public static final int DEFAULT_MIN_DOC_FREQ = 5;
    public static final int DEFAULT_MAX_DOC_FREQ = Integer.MAX_VALUE;
    public static final boolean DEFAULT_BOOST = false;
    public static final String[] DEFAULT_FIELD_NAMES = new String[]{"contents"};
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    public static final Set<?> DEFAULT_STOP_WORDS = null;
    private Set<?> stopWords = DEFAULT_STOP_WORDS;
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    private Analyzer analyzer = null;
    private int minTermFreq = 2;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private boolean boost = false;
    private Set<Term> skipTerms = null;
    private String[] fieldNames = DEFAULT_FIELD_NAMES;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private int maxQueryTerms = 25;
    private final TFIDFSimilarity similarity;
    private final IndexReader ir;
    private float boostFactor = 1.0f;

    public void setBoostFactor(float boostFactor) {
        this.boostFactor = boostFactor;
    }

    public void setSkipTerms(Set<Term> skipTerms) {
        this.skipTerms = skipTerms;
    }

    public XMoreLikeThis(IndexReader ir, TFIDFSimilarity sim) {
        this.ir = ir;
        this.similarity = sim;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setMinTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public void setMaxDocFreq(int maxFreq) {
        this.maxDocFreq = maxFreq;
    }

    public void setBoost(boolean boost) {
        this.boost = boost;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public Query like(String fieldName, Reader ... readers) throws IOException {
        HashMap<String, Int> words = new HashMap<String, Int>();
        for (Reader r : readers) {
            this.addTermFrequencies(r, words, fieldName);
        }
        return this.createQuery(this.createQueue(words));
    }

    public Query like(Fields ... likeFields) throws IOException {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Fields fields : likeFields) {
            for (String fieldName : fields) {
                fieldNames.add(fieldName);
            }
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (String fieldName : fieldNames) {
            HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
            for (Fields fields : likeFields) {
                Terms vector = fields.terms(fieldName);
                if (vector == null) continue;
                this.addTermFrequencies(termFreqMap, vector, fieldName);
            }
            this.addToQuery(this.createQueue(termFreqMap, fieldName), bq);
        }
        return bq.build();
    }

    private Query createQuery(PriorityQueue<ScoreTerm> q) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        this.addToQuery(q, query);
        return query.build();
    }

    private void addToQuery(PriorityQueue<ScoreTerm> q, BooleanQuery.Builder query) {
        ScoreTerm scoreTerm;
        float bestScore = -1.0f;
        while ((scoreTerm = q.pop()) != null) {
            Query tq = new TermQuery(new Term(scoreTerm.topField, scoreTerm.word));
            if (this.boost) {
                if (bestScore == -1.0f) {
                    bestScore = scoreTerm.score;
                }
                float myScore = scoreTerm.score;
                tq = new BoostQuery(tq, this.boostFactor * myScore / bestScore);
            }
            try {
                query.add(tq, BooleanClause.Occur.SHOULD);
            }
            catch (IndexSearcher.TooManyClauses ignore) {
                break;
            }
        }
    }

    private PriorityQueue<ScoreTerm> createQueue(Map<String, Int> words) throws IOException {
        return this.createQueue(words, this.fieldNames);
    }

    private PriorityQueue<ScoreTerm> createQueue(Map<String, Int> words, String ... fieldNames) throws IOException {
        int numDocs = this.ir.numDocs();
        int limit = Math.min(this.maxQueryTerms, words.size());
        FreqQ queue = new FreqQ(limit);
        for (String word : words.keySet()) {
            int tf = words.get((Object)word).x;
            if (this.minTermFreq > 0 && tf < this.minTermFreq) continue;
            String topField = fieldNames[0];
            int docFreq = 0;
            for (String fieldName : fieldNames) {
                int freq = this.ir.docFreq(new Term(fieldName, word));
                topField = freq > docFreq ? fieldName : topField;
                docFreq = Math.max(freq, docFreq);
            }
            if (this.minDocFreq > 0 && docFreq < this.minDocFreq || docFreq > this.maxDocFreq || docFreq == 0) continue;
            float idf = this.similarity.idf(docFreq, numDocs);
            float score = (float)tf * idf;
            if (queue.size() < limit) {
                queue.add(new ScoreTerm(word, topField, score));
                continue;
            }
            ScoreTerm term = (ScoreTerm)queue.top();
            if (!(term.score < score)) continue;
            term.update(word, topField, score);
            queue.updateTop();
        }
        return queue;
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, Terms vector, @Nullable String fieldName) throws IOException {
        BytesRef text;
        TermsEnum termsEnum = vector.iterator();
        CharsRefBuilder spare = new CharsRefBuilder();
        while ((text = termsEnum.next()) != null) {
            spare.copyUTF8Bytes(text);
            String term = spare.toString();
            if (this.isNoiseWord(term) || this.isSkipTerm(fieldName, term)) continue;
            PostingsEnum docs = termsEnum.postings(null);
            int freq = 0;
            while (docs != null && docs.nextDoc() != Integer.MAX_VALUE) {
                freq += docs.freq();
            }
            Int cnt = termFreqMap.get(term);
            if (cnt == null) {
                cnt = new Int();
                termFreqMap.put(term, cnt);
                cnt.x = freq;
                continue;
            }
            cnt.x += freq;
        }
    }

    private void addTermFrequencies(Reader r, Map<String, Int> termFreqMap, String fieldName) throws IOException {
        if (this.analyzer == null) {
            throw new UnsupportedOperationException("To use MoreLikeThis without term vectors, you must provide an Analyzer");
        }
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, r);){
            int tokenCount = 0;
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            TermFrequencyAttribute tfAtt = ts.addAttribute(TermFrequencyAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String word = termAtt.toString();
                if (++tokenCount > 5000) break;
                if (this.isNoiseWord(word) || this.isSkipTerm(fieldName, word)) continue;
                Int cnt = termFreqMap.get(word);
                if (cnt == null) {
                    termFreqMap.put(word, new Int(tfAtt.getTermFrequency()));
                    continue;
                }
                cnt.x += tfAtt.getTermFrequency();
            }
            ts.end();
        }
    }

    private boolean isNoiseWord(String term) {
        int len = term.length();
        if (this.minWordLen > 0 && len < this.minWordLen) {
            return true;
        }
        if (this.maxWordLen > 0 && len > this.maxWordLen) {
            return true;
        }
        return this.stopWords != null && this.stopWords.contains(term);
    }

    private boolean isSkipTerm(@Nullable String field, String value) {
        return field != null && this.skipTerms != null && this.skipTerms.contains(new Term(field, value));
    }

    private static class ScoreTerm {
        String word;
        String topField;
        float score;

        ScoreTerm(String word, String topField, float score) {
            this.word = word;
            this.topField = topField;
            this.score = score;
        }

        void update(String word, String topField, float score) {
            this.word = word;
            this.topField = topField;
            this.score = score;
        }
    }

    private static class FreqQ
    extends PriorityQueue<ScoreTerm> {
        FreqQ(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(ScoreTerm a, ScoreTerm b) {
            return a.score < b.score;
        }
    }

    private static class Int {
        private int x;

        private Int(int initialValue) {
            this.x = initialValue;
        }

        private Int() {
            this(1);
        }
    }
}

