/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.common.lucene.index.ElasticsearchLeafReader;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ESCacheHelper;

public final class ElasticsearchDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;
    @Nullable
    private final ESCacheHelper esCacheHelper;

    private ElasticsearchDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId, @Nullable ESCacheHelper esCacheHelper) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
        this.esCacheHelper = esCacheHelper;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new ElasticsearchDirectoryReader(in, this.wrapper, this.shardId, this.esCacheHelper);
    }

    public static ElasticsearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return ElasticsearchDirectoryReader.wrap(reader, shardId, null);
    }

    public static ElasticsearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId, @Nullable ESCacheHelper esCacheHelper) throws IOException {
        return new ElasticsearchDirectoryReader(reader, new SubReaderWrapper(shardId), shardId, esCacheHelper);
    }

    public static ESCacheHelper getESReaderCacheHelper(DirectoryReader reader) {
        ElasticsearchDirectoryReader esReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader);
        assert (esReader != null);
        if (esReader == null || esReader.esCacheHelper == null) {
            return new ESCacheHelper.Wrapper(reader.getReaderCacheHelper());
        }
        return esReader.esCacheHelper;
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ClosedListener listener) {
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader);
        if (elasticsearchDirectoryReader == null) {
            throw new IllegalArgumentException("Can't install close listener reader is not an ElasticsearchDirectoryReader/ElasticsearchLeafReader");
        }
        IndexReader.CacheHelper cacheHelper = elasticsearchDirectoryReader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf(elasticsearchDirectoryReader) + " does not support caching");
        }
        assert (cacheHelper.getKey() == reader.getReaderCacheHelper().getKey());
        cacheHelper.addClosedListener(listener);
    }

    public static ElasticsearchDirectoryReader getElasticsearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof ElasticsearchDirectoryReader) {
                return (ElasticsearchDirectoryReader)reader;
            }
            return ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return new ElasticsearchLeafReader(reader, this.shardId);
        }
    }
}

