/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Map;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeights;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.WeightFunction;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;

public class NodeAllocationStatsAndWeightsCalculator {
    private final WriteLoadForecaster writeLoadForecaster;
    private final BalancingWeightsFactory balancingWeightsFactory;

    public NodeAllocationStatsAndWeightsCalculator(WriteLoadForecaster writeLoadForecaster, BalancingWeightsFactory balancingWeightsFactory) {
        this.writeLoadForecaster = writeLoadForecaster;
        this.balancingWeightsFactory = balancingWeightsFactory;
    }

    public Map<String, NodeAllocationStatsAndWeight> nodesAllocationStatsAndWeights(Metadata metadata, RoutingNodes routingNodes, ClusterInfo clusterInfo, Runnable ensureNotCancelled, @Nullable DesiredBalance desiredBalance) {
        if (metadata.hasAnyIndices()) {
            this.writeLoadForecaster.refreshLicense();
        }
        BalancingWeights balancingWeights = this.balancingWeightsFactory.create();
        float avgShardsPerNode = WeightFunction.avgShardPerNode(metadata, routingNodes);
        double avgWriteLoadPerNode = WeightFunction.avgWriteLoadPerNode(this.writeLoadForecaster, metadata, routingNodes);
        double avgDiskUsageInBytesPerNode = WeightFunction.avgDiskUsageInBytesPerNode(clusterInfo, metadata, routingNodes);
        Map<String, NodeAllocationStatsAndWeight> nodeAllocationStatsAndWeights = Maps.newMapWithExpectedSize(routingNodes.size());
        for (RoutingNode node : routingNodes) {
            WeightFunction weightFunction = balancingWeights.weightFunctionForNode(node);
            int shards = 0;
            int undesiredShards = 0;
            double forecastedWriteLoad = 0.0;
            long forecastedDiskUsage = 0L;
            long currentDiskUsage = 0L;
            for (ShardRouting shardRouting : node) {
                ensureNotCancelled.run();
                if (shardRouting.relocating()) continue;
                ++shards;
                IndexMetadata indexMetadata = metadata.indexMetadata(shardRouting.index());
                if (!NodeAllocationStatsAndWeightsCalculator.isDesiredAllocation(desiredBalance, shardRouting)) {
                    ++undesiredShards;
                }
                long shardSize = clusterInfo.getShardSize(shardRouting.shardId(), shardRouting.primary(), 0L);
                forecastedWriteLoad += this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
                forecastedDiskUsage += Math.max(indexMetadata.getForecastedShardSizeInBytes().orElse(0L), shardSize);
                currentDiskUsage += shardSize;
            }
            float currentNodeWeight = weightFunction.calculateNodeWeight(shards, avgShardsPerNode, forecastedWriteLoad, avgWriteLoadPerNode, currentDiskUsage, avgDiskUsageInBytesPerNode);
            nodeAllocationStatsAndWeights.put(node.nodeId(), new NodeAllocationStatsAndWeight(shards, desiredBalance != null ? undesiredShards : -1, forecastedWriteLoad, forecastedDiskUsage, currentDiskUsage, currentNodeWeight));
        }
        return nodeAllocationStatsAndWeights;
    }

    private static boolean isDesiredAllocation(@Nullable DesiredBalance desiredBalance, ShardRouting shardRouting) {
        if (desiredBalance == null) {
            return true;
        }
        ShardAssignment assignment = desiredBalance.getAssignment(shardRouting.shardId());
        if (assignment == null) {
            return false;
        }
        return assignment.nodeIds().contains(shardRouting.currentNodeId());
    }

    public record NodeAllocationStatsAndWeight(int shards, int undesiredShards, double forecastedIngestLoad, long forecastedDiskUsage, long currentDiskUsage, float currentNodeWeight) {
    }
}

