/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestClusterGetSettingsResponse
implements ToXContentObject {
    private final Settings persistentSettings;
    private final Settings transientSettings;
    private final Settings defaultSettings;
    public static final String PERSISTENT_FIELD = "persistent";
    public static final String TRANSIENT_FIELD = "transient";
    public static final String DEFAULTS_FIELD = "defaults";

    public RestClusterGetSettingsResponse(Settings persistentSettings, Settings transientSettings, Settings defaultSettings) {
        this.persistentSettings = Objects.requireNonNullElse(persistentSettings, Settings.EMPTY);
        this.transientSettings = Objects.requireNonNullElse(transientSettings, Settings.EMPTY);
        this.defaultSettings = Objects.requireNonNullElse(defaultSettings, Settings.EMPTY);
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    public String getSetting(String setting) {
        if (this.persistentSettings.hasValue(setting)) {
            return this.persistentSettings.get(setting);
        }
        if (this.transientSettings.hasValue(setting)) {
            return this.transientSettings.get(setting);
        }
        if (this.defaultSettings.hasValue(setting)) {
            return this.defaultSettings.get(setting);
        }
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(PERSISTENT_FIELD);
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT_FIELD);
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
        if (!this.defaultSettings.isEmpty()) {
            builder.startObject(DEFAULTS_FIELD);
            this.defaultSettings.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClusterGetSettingsResponse that = (RestClusterGetSettingsResponse)o;
        return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings) && Objects.equals(this.defaultSettings, that.defaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.transientSettings, this.persistentSettings, this.defaultSettings);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

