/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.filters.elasticintegration.EventToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.AbstractSimpleResolver;
import co.elastic.logstash.filters.elasticintegration.util.EventUtil;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SprintfTemplateEventToPipelineNameResolver
extends AbstractSimpleResolver<Event, String>
implements EventToPipelineNameResolver {
    private static final Logger DEFAULT_LOGGER = LogManager.getLogger(SprintfTemplateEventToPipelineNameResolver.class);
    private final String template;
    private final Logger logger;
    private static final String TEMPLATE_REFERENCE_START = "%{";

    public static EventToPipelineNameResolver from(String template) {
        if (template.contains(TEMPLATE_REFERENCE_START)) {
            return new SprintfTemplateEventToPipelineNameResolver(template);
        }
        Optional<String> constantReturn = Optional.of(template);
        return (event, exceptionHandler) -> constantReturn;
    }

    SprintfTemplateEventToPipelineNameResolver(String template) {
        this(template, DEFAULT_LOGGER);
    }

    SprintfTemplateEventToPipelineNameResolver(String template, Logger logger) {
        this.template = template;
        this.logger = logger;
    }

    @Override
    public Optional<String> resolveSafely(Event resolveKey) throws Exception {
        String result = resolveKey.sprintf(this.template);
        if (result.contains(TEMPLATE_REFERENCE_START)) {
            this.logger.trace(() -> String.format("sprintf template `%s` failed to resolve one or more fields `%s` in %s", this.template, result, EventUtil.serializeEventForLog(this.logger, resolveKey)));
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

