/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch.text_structure.TopHit;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldStat
implements JsonpSerializable {
    private final int count;
    private final int cardinality;
    private final List<TopHit> topHits;
    @Nullable
    private final Integer meanValue;
    @Nullable
    private final Integer medianValue;
    @Nullable
    private final Integer maxValue;
    @Nullable
    private final Integer minValue;
    @Nullable
    private final String earliest;
    @Nullable
    private final String latest;
    public static final JsonpDeserializer<FieldStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldStat::setupFieldStatDeserializer);

    private FieldStat(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.cardinality = ApiTypeHelper.requireNonNull(builder.cardinality, (Object)this, "cardinality", 0);
        this.topHits = ApiTypeHelper.unmodifiableRequired(builder.topHits, (Object)this, "topHits");
        this.meanValue = builder.meanValue;
        this.medianValue = builder.medianValue;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
        this.earliest = builder.earliest;
        this.latest = builder.latest;
    }

    public static FieldStat of(Function<Builder, ObjectBuilder<FieldStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final int cardinality() {
        return this.cardinality;
    }

    public final List<TopHit> topHits() {
        return this.topHits;
    }

    @Nullable
    public final Integer meanValue() {
        return this.meanValue;
    }

    @Nullable
    public final Integer medianValue() {
        return this.medianValue;
    }

    @Nullable
    public final Integer maxValue() {
        return this.maxValue;
    }

    @Nullable
    public final Integer minValue() {
        return this.minValue;
    }

    @Nullable
    public final String earliest() {
        return this.earliest;
    }

    @Nullable
    public final String latest() {
        return this.latest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("cardinality");
        generator.write(this.cardinality);
        if (ApiTypeHelper.isDefined(this.topHits)) {
            generator.writeKey("top_hits");
            generator.writeStartArray();
            for (TopHit item0 : this.topHits) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.meanValue != null) {
            generator.writeKey("mean_value");
            generator.write(this.meanValue);
        }
        if (this.medianValue != null) {
            generator.writeKey("median_value");
            generator.write(this.medianValue);
        }
        if (this.maxValue != null) {
            generator.writeKey("max_value");
            generator.write(this.maxValue);
        }
        if (this.minValue != null) {
            generator.writeKey("min_value");
            generator.write(this.minValue);
        }
        if (this.earliest != null) {
            generator.writeKey("earliest");
            generator.write(this.earliest);
        }
        if (this.latest != null) {
            generator.writeKey("latest");
            generator.write(this.latest);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::cardinality, JsonpDeserializer.integerDeserializer(), "cardinality");
        op.add(Builder::topHits, JsonpDeserializer.arrayDeserializer(TopHit._DESERIALIZER), "top_hits");
        op.add(Builder::meanValue, JsonpDeserializer.integerDeserializer(), "mean_value");
        op.add(Builder::medianValue, JsonpDeserializer.integerDeserializer(), "median_value");
        op.add(Builder::maxValue, JsonpDeserializer.integerDeserializer(), "max_value");
        op.add(Builder::minValue, JsonpDeserializer.integerDeserializer(), "min_value");
        op.add(Builder::earliest, JsonpDeserializer.stringDeserializer(), "earliest");
        op.add(Builder::latest, JsonpDeserializer.stringDeserializer(), "latest");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldStat> {
        private Integer count;
        private Integer cardinality;
        private List<TopHit> topHits;
        @Nullable
        private Integer meanValue;
        @Nullable
        private Integer medianValue;
        @Nullable
        private Integer maxValue;
        @Nullable
        private Integer minValue;
        @Nullable
        private String earliest;
        @Nullable
        private String latest;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder cardinality(int value) {
            this.cardinality = value;
            return this;
        }

        public final Builder topHits(List<TopHit> list) {
            this.topHits = Builder._listAddAll(this.topHits, list);
            return this;
        }

        public final Builder topHits(TopHit value, TopHit ... values) {
            this.topHits = Builder._listAdd(this.topHits, value, values);
            return this;
        }

        public final Builder topHits(Function<TopHit.Builder, ObjectBuilder<TopHit>> fn) {
            return this.topHits(fn.apply(new TopHit.Builder()).build(), new TopHit[0]);
        }

        public final Builder meanValue(@Nullable Integer value) {
            this.meanValue = value;
            return this;
        }

        public final Builder medianValue(@Nullable Integer value) {
            this.medianValue = value;
            return this;
        }

        public final Builder maxValue(@Nullable Integer value) {
            this.maxValue = value;
            return this;
        }

        public final Builder minValue(@Nullable Integer value) {
            this.minValue = value;
            return this;
        }

        public final Builder earliest(@Nullable String value) {
            this.earliest = value;
            return this;
        }

        public final Builder latest(@Nullable String value) {
            this.latest = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldStat build() {
            this._checkSingleUse();
            return new FieldStat(this);
        }
    }
}

