"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataConnectorsServerPlugin = void 0;
var _data_sources = require("./data_sources");
var _register = require("./register");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataConnectorsServerPlugin {
  constructor(context) {}
  setup(core, plugins) {
    const {
      uiSettings
    } = core;
    const {
      dataSourcesRegistry
    } = plugins;

    // Register WorkplaceAI-owned data sources
    (0, _data_sources.registerDataSources)(dataSourcesRegistry);
    (0, _register.registerUISettings)({
      uiSettings
    });
    return {};
  }
  start(core) {
    return {};
  }
}
exports.DataConnectorsServerPlugin = DataConnectorsServerPlugin;