"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notionDataSource = void 0;
var _i18n = require("@kbn/i18n");
var _data_type = require("@kbn/data-sources-registry-plugin/server/data_catalog/data_type");
var _workflows = require("./workflows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const notionDataSource = exports.notionDataSource = {
  id: 'notion',
  name: 'Notion',
  description: _i18n.i18n.translate('xpack.dataConnectors.dataSources.notion.description', {
    defaultMessage: 'Connect to Notion to pull data from your workspace.'
  }),
  oauthConfiguration: {
    provider: _data_type.EARSSupportedOAuthProvider.NOTION,
    initiatePath: '/oauth/start/notion',
    fetchSecretsPath: '/oauth/fetch_request_secrets',
    oauthBaseUrl: 'https://localhost:8052'
  },
  stackConnector: {
    type: '.notion',
    config: {}
  },
  generateWorkflows(stackConnectorId) {
    return [{
      content: (0, _workflows.generateQueryWorkflow)(stackConnectorId),
      shouldGenerateABTool: true
    }, {
      content: (0, _workflows.generateSearchWorkflow)(stackConnectorId),
      shouldGenerateABTool: true
    }, {
      content: (0, _workflows.generateGetPageWorkflow)(stackConnectorId),
      shouldGenerateABTool: true
    }, {
      content: (0, _workflows.generateGetDataSourceWorkflow)(stackConnectorId),
      shouldGenerateABTool: true
    }];
  }
};