"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformOptionsIn = transformOptionsIn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const APIToSavedObjectOptionsKeys = {
  hide_panel_titles: 'hidePanelTitles',
  use_margins: 'useMargins',
  sync_colors: 'syncColors',
  sync_tooltips: 'syncTooltips',
  sync_cursor: 'syncCursor'
};
function transformOptionsIn(options) {
  const apiOptions = options !== null && options !== void 0 ? options : {};
  const savedObjectOptions = {};
  Object.keys(apiOptions).forEach(key => {
    const apiKey = key;
    const soKey = APIToSavedObjectOptionsKeys[apiKey];
    if (soKey) savedObjectOptions[soKey] = apiOptions[apiKey];
  });
  return JSON.stringify(savedObjectOptions);
}