"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchResponseBodySchema = exports.searchRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _meta_schemas = require("../meta_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchRequestBodySchema = exports.searchRequestBodySchema = _configSchema.schema.object({
  page: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'The page of dashboards to return'
    }
  })),
  per_page: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'The number of dashboards to return per page'
    }
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An Elasticsearch simple_query_string query that filters the dashboards in the response by "title" and "description"'
    }
  })),
  tags: _configSchema.schema.maybe(_configSchema.schema.object({
    included: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    excluded: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))
});
const searchResponseBodySchema = exports.searchResponseBodySchema = _configSchema.schema.object({
  dashboards: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    data: _configSchema.schema.object({
      description: _configSchema.schema.maybe(_configSchema.schema.string()),
      tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      time_range: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema),
      title: _configSchema.schema.string()
    }),
    meta: _configSchema.schema.allOf([_meta_schemas.baseMetaSchema, _meta_schemas.createdMetaSchema, _meta_schemas.updatedMetaSchema])
  })),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number()
});