"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.read = read;
var _constants = require("../../../common/constants");
var _saved_object_utils = require("../saved_object_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function read(requestCtx, id) {
  const {
    core
  } = await requestCtx.resolve(['core']);
  const {
    saved_object: savedObject,
    outcome,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alias_purpose,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    alias_target_id
  } = await core.savedObjects.client.resolve(_constants.DASHBOARD_SAVED_OBJECT_TYPE, id);
  const response = (0, _saved_object_utils.getDashboardCRUResponseBody)(savedObject, 'read');
  return {
    ...response,
    meta: {
      ...response.meta,
      alias_target_id,
      alias_purpose,
      outcome
    }
  };
}