"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardLocatorParamsFromEmbeddable = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDashboardLocatorParamsFromEmbeddable = (api, options) => {
  var _api$parentApi, _api$parentApi$query$, _api$timeRange$$value, _api$timeRange$, _api$parentApi2, _api$parentApi2$timeR, _api$parentApi$filter, _api$parentApi3, _api$parentApi3$filte;
  const params = {};
  const query = (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : (_api$parentApi$query$ = _api$parentApi.query$) === null || _api$parentApi$query$ === void 0 ? void 0 : _api$parentApi$query$.value;
  if (query && options.useCurrentFilters) {
    params.query = query;
  }

  // if useCurrentDashboardDataRange is enabled, then preserve current time range
  // if undefined is passed, then destination dashboard will figure out time range itself
  // for brush event this time range would be overwritten
  const timeRange = (_api$timeRange$$value = (_api$timeRange$ = api.timeRange$) === null || _api$timeRange$ === void 0 ? void 0 : _api$timeRange$.value) !== null && _api$timeRange$$value !== void 0 ? _api$timeRange$$value : (_api$parentApi2 = api.parentApi) === null || _api$parentApi2 === void 0 ? void 0 : (_api$parentApi2$timeR = _api$parentApi2.timeRange$) === null || _api$parentApi2$timeR === void 0 ? void 0 : _api$parentApi2$timeR.value;
  if (timeRange && options.useCurrentDateRange) {
    params.time_range = timeRange;
  }

  // if useCurrentDashboardFilters enabled, then preserve all the filters (pinned, unpinned, and from controls)
  // otherwise preserve only pinned
  const filters = (_api$parentApi$filter = (_api$parentApi3 = api.parentApi) === null || _api$parentApi3 === void 0 ? void 0 : (_api$parentApi3$filte = _api$parentApi3.filters$) === null || _api$parentApi3$filte === void 0 ? void 0 : _api$parentApi3$filte.value) !== null && _api$parentApi$filter !== void 0 ? _api$parentApi$filter : [];
  params.filters = options.useCurrentFilters ? filters : filters === null || filters === void 0 ? void 0 : filters.filter(f => (0, _esQuery.isFilterPinned)(f));
  return params;
};
exports.getDashboardLocatorParamsFromEmbeddable = getDashboardLocatorParamsFromEmbeddable;