"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditor = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react2 = _interopRequireWildcard(require("react"));
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _markdown_footer = require("./markdown_footer");
var _markdown_renderer = require("./markdown_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard_markdown/public/components/markdown_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const componentStyles = {
  rootContainer: (0, _react.css)({
    display: 'flex',
    width: '100%',
    containerType: 'size'
  }),
  container: (0, _react.css)({
    width: '100%'
  }),
  componentInvisible: (0, _react.css)({
    opacity: 0,
    pointerEvents: 'none',
    userSelect: 'none',
    position: 'absolute'
  }),
  editorStyles: ({
    euiTheme
  }) => (0, _react.css)({
    blockSize: `calc(100% - ${euiTheme.size.xxl})`,
    width: '100%',
    '.euiMarkdownEditorDropZone': {
      minBlockSize: 'initial'
    },
    textarea: {
      minBlockSize: 'initial'
    },
    [_markdown_footer.SHORT_CONTAINER_QUERY]: {
      blockSize: `100%`,
      // TODO: Do not use data-test-subj to style - should be fixed in EUI
      '[data-test-subj="euiMarkdownEditorToolbar"]': {
        display: 'none'
      }
    }
  })
};
const strings = {
  placeholder: _i18n.i18n.translate('dashboardMarkdown.placeholder', {
    defaultMessage: 'Use Markdown to format your text'
  }),
  ariaLabel: _i18n.i18n.translate('dashboardMarkdown.embeddableAriaLabel', {
    defaultMessage: 'Dashboard markdown editor'
  })
};
const MarkdownEditor = ({
  processingPluginList,
  content,
  onCancel,
  onSave,
  isPreview$,
  uiPlugins = []
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const isPreview = (0, _presentationPublishing.useStateFromPublishingSubject)(isPreview$);
  const [value, onChange] = _react2.default.useState(content);
  const editorRef = (0, _react2.useRef)(null);
  const cancelButtonRef = (0, _react2.useRef)(null);
  useCaretPosition(editorRef, !isPreview);
  const isSaveable = Boolean(value === '' || value !== content);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.rootContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: [styles.container, isPreview && styles.componentInvisible],
    onKeyDown: e => {
      if (e.key === 'Escape') {
        var _cancelButtonRef$curr;
        (_cancelButtonRef$curr = cancelButtonRef.current) === null || _cancelButtonRef$curr === void 0 ? void 0 : _cancelButtonRef$curr.focus();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownEditor, {
    value: value,
    onChange: onChange,
    "aria-label": strings.ariaLabel,
    placeholder: strings.placeholder,
    processingPluginList: processingPluginList,
    height: "full",
    ref: editorRef,
    css: styles.editorStyles,
    "aria-describedby": _markdown_footer.FOOTER_HELP_TEXT,
    showFooter: false,
    toolbarProps: {
      right: /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownEditorHelpButton, {
        uiPlugins: uiPlugins,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 20
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), isPreview && /*#__PURE__*/_react2.default.createElement(_markdown_renderer.MarkdownRenderer, {
    processingPluginList: processingPluginList,
    content: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_markdown_footer.MarkdownFooter, {
    onCancel: onCancel,
    onSave: () => onSave(value),
    isPreview: isPreview,
    cancelButtonRef: cancelButtonRef,
    isSaveable: isSaveable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
};
exports.MarkdownEditor = MarkdownEditor;
function useCaretPosition(ref, shouldFocus) {
  var _ref$current2, _ref$current4;
  const caretPosRef = (0, _react2.useRef)(null);

  // Keep caretPosRef updated
  (0, _react2.useLayoutEffect)(() => {
    var _ref$current;
    const textarea = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.textarea;
    if (!textarea) return;
    const updateCaret = () => {
      caretPosRef.current = textarea.selectionStart;
    };
    textarea.addEventListener('input', updateCaret);
    textarea.addEventListener('click', updateCaret);
    textarea.addEventListener('keyup', updateCaret);
    return () => {
      textarea.removeEventListener('input', updateCaret);
      textarea.removeEventListener('click', updateCaret);
      textarea.removeEventListener('keyup', updateCaret);
    };
  }, [(_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.textarea, ref]);

  // Restore caret when needed (preview -> editor)
  (0, _react2.useLayoutEffect)(() => {
    var _ref$current3;
    if (!shouldFocus) return;
    const textarea = (_ref$current3 = ref.current) === null || _ref$current3 === void 0 ? void 0 : _ref$current3.textarea;
    if (!textarea) return;
    textarea.focus();
    if (caretPosRef.current === null) {
      // focus at end of first line
      const newlineIndex = textarea.value.indexOf('\n');
      const firstLineEnd = newlineIndex === -1 ? textarea.value.length : newlineIndex;
      textarea.setSelectionRange(firstLineEnd, firstLineEnd);
    } else {
      textarea.setSelectionRange(caretPosRef.current, caretPosRef.current);
    }
  }, [shouldFocus, (_ref$current4 = ref.current) === null || _ref$current4 === void 0 ? void 0 : _ref$current4.textarea, ref]);
  return caretPosRef;
}