"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsDashboardAgentEnabled = getIsDashboardAgentEnabled;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIsDashboardAgentEnabled(core) {
  const [coreStart] = await core.getStartServices();
  const isFeatureFlagEnabled = await coreStart.featureFlags.getBooleanValue(_constants.DASHBOARD_AGENT_FEATURE_FLAG, _constants.DASHBOARD_AGENT_FEATURE_FLAG_DEFAULT);
  return isFeatureFlagEnabled;
}