"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizePanels = exports.checkDashboardToolsAvailability = void 0;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _constants = require("@kbn/dashboard-plugin/common/constants");
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared availability handler for all dashboard tools.
 * Checks if dashboard tools are enabled via UI settings.
 */
const checkDashboardToolsAvailability = async ({
  uiSettings
}) => {
  const enabled = await uiSettings.get(_managementSettingsIds.AGENT_BUILDER_DASHBOARD_TOOLS_SETTING_ID);
  return {
    status: enabled ? 'available' : 'unavailable'
  };
};

/**
 * Normalizes panel configurations to the correct DashboardPanel format.
 * This is a temporary function to handle lens API schema conversion.
 */
exports.checkDashboardToolsAvailability = checkDashboardToolsAvailability;
const normalizePanels = panels => {
  return (panels !== null && panels !== void 0 ? panels : []).map((panel, index) => {
    return buildLensPanelFromApi(panel, index);
  });
};
exports.normalizePanels = normalizePanels;
const buildLensPanelFromApi = (config, index) => {
  var _ref, _lensAttributes$title;
  const lensAttributes = new _config_builder.LensConfigBuilder().fromAPIFormat(config);
  const lensConfig = {
    title: (_ref = (_lensAttributes$title = lensAttributes.title) !== null && _lensAttributes$title !== void 0 ? _lensAttributes$title : config.title) !== null && _ref !== void 0 ? _ref : 'Generated panel',
    attributes: lensAttributes
  };
  return {
    type: 'lens',
    grid: createDefaultGrid(index),
    config: lensConfig
  };
};
const createDefaultGrid = (index, existing) => {
  var _existing$x, _existing$y, _existing$w, _existing$h;
  const yOffset = index * _constants.DEFAULT_PANEL_HEIGHT;
  return {
    x: (_existing$x = existing === null || existing === void 0 ? void 0 : existing.x) !== null && _existing$x !== void 0 ? _existing$x : 0,
    y: (_existing$y = existing === null || existing === void 0 ? void 0 : existing.y) !== null && _existing$y !== void 0 ? _existing$y : yOffset,
    w: (_existing$w = existing === null || existing === void 0 ? void 0 : existing.w) !== null && _existing$w !== void 0 ? _existing$w : _constants.DEFAULT_PANEL_WIDTH,
    h: (_existing$h = existing === null || existing === void 0 ? void 0 : existing.h) !== null && _existing$h !== void 0 ? _existing$h : _constants.DEFAULT_PANEL_HEIGHT
  };
};