"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/index-management-plugin/public");
var _eui = require("@elastic/eui");
var _routing = require("../../../../../services/routing");
var _components = require("../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/home/auto_follow_pattern_list/components/detail_panel/detail_panel.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DetailPanel extends _react.Component {
  renderAutoFollowPattern({
    followIndexPatternPrefix,
    followIndexPatternSuffix,
    remoteCluster,
    leaderIndexPatterns,
    active
  }) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.statusLabel",
      defaultMessage: "Status",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "status",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, !active ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.pausedStatus",
      defaultMessage: "Paused",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 19
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.activeStatus",
      defaultMessage: "Active",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "ccrAutoFollowPatternDetailSettingsTitle",
      "data-test-subj": "settingsSection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: "ccrAutoFollowPatternDetailSettingsTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.statusTitle",
      defaultMessage: "Settings",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.remoteClusterLabel",
      defaultMessage: "Remote cluster",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteCluster",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 17
      }
    }, remoteCluster))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.leaderPatternsLabel",
      defaultMessage: "Leader patterns",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "leaderIndexPatterns",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }, leaderIndexPatterns.join(', '))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.prefixLabel",
      defaultMessage: "Prefix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "patternPrefix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }, followIndexPatternPrefix || /*#__PURE__*/_react.default.createElement("em", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.prefixEmptyValue",
      defaultMessage: "No prefix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 23
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      "data-test-subj": "settingsValues",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.suffixLabel",
      defaultMessage: "Suffix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "patternSuffix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 17
      }
    }, followIndexPatternSuffix || /*#__PURE__*/_react.default.createElement("em", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.suffixEmptyValue",
      defaultMessage: "No suffix",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 23
      }
    }))))))));
  }
  renderIndicesPreview(prefix, suffix, leaderIndexPatterns) {
    return /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "indicesPreviewSection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternIndicesPreview, {
      prefix: prefix,
      suffix: suffix,
      leaderIndexPatterns: leaderIndexPatterns,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }));
  }
  renderAutoFollowPatternNotFound() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.notFoundLabel",
      defaultMessage: "Auto-follow pattern not found",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 17
      }
    }))))));
  }
  renderAutoFollowPatternErrors(autoFollowPattern) {
    if (!autoFollowPattern.errors.length) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "errors",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      "data-test-subj": "titleErrors",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.recentErrorsTitle",
      defaultMessage: "Recent errors",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 17
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 11
      }
    }, autoFollowPattern.errors.map((error, i) => /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      "data-test-subj": "recentError",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 17
      }
    }, (0, _moment.default)(error.timestamp).format('MMMM Do, YYYY h:mm:ss A')), ":", ' ', error.autoFollowException.reason)))));
  }
  renderFlyoutBody() {
    const {
      autoFollowPattern
    } = this.props;
    if (!autoFollowPattern) {
      return this.renderAutoFollowPatternNotFound();
    }
    const {
      followIndexPatternPrefix,
      followIndexPatternSuffix,
      leaderIndexPatterns
    } = autoFollowPattern;
    let indexManagementFilter;
    if (followIndexPatternPrefix) {
      indexManagementFilter = `name:${followIndexPatternPrefix}`;
    } else if (followIndexPatternSuffix) {
      indexManagementFilter = `name:${followIndexPatternSuffix}`;
    }
    const indexManagementUri = (0, _public.getIndexListUri)(indexManagementFilter);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 7
      }
    }, this.renderAutoFollowPattern(autoFollowPattern), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 9
      }
    }), this.renderIndicesPreview(followIndexPatternPrefix, followIndexPatternSuffix, leaderIndexPatterns), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _routing.routing._reactRouter.getUrlForApp('management', {
        path: `data/index_management${indexManagementUri}`
      }),
      "data-test-subj": "viewIndexManagementLink",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.viewIndicesLink",
      defaultMessage: "View your follower indices in Index Management",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 9
      }
    }), this.renderAutoFollowPatternErrors(autoFollowPattern));
  }
  renderFlyoutFooter() {
    const {
      autoFollowPattern,
      closeDetailPanel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: closeDetailPanel,
      "data-test-subj": "closeFlyoutButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternDetailPanel.closeButtonLabel",
      defaultMessage: "Close",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 15
      }
    }))), autoFollowPattern && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternActionMenu, {
      edit: true,
      arrowDirection: "up",
      patterns: [autoFollowPattern],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 19
      }
    }))))));
  }
  render() {
    const {
      autoFollowPatternId,
      closeDetailPanel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      "data-test-subj": "autoFollowPatternDetail",
      onClose: closeDetailPanel,
      "aria-labelledby": "autoFollowPatternDetailsFlyoutTitle",
      size: "m",
      maxWidth: 400,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      id: "autoFollowPatternDetailsFlyoutTitle",
      "data-test-subj": "title",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 13
      }
    }, autoFollowPatternId))), this.renderFlyoutBody(), this.renderFlyoutFooter());
  }
}
exports.DetailPanel = DetailPanel;
(0, _defineProperty2.default)(DetailPanel, "propTypes", {
  apiStatus: _propTypes.default.string,
  autoFollowPatternId: _propTypes.default.string,
  autoFollowPattern: _propTypes.default.object,
  closeDetailPanel: _propTypes.default.func.isRequired
});