"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _editor_constants = require("../../controls/data_controls/editor_constants");
var _control_group_strings = require("../control_group_strings");
var _control_setting_tooltip_label = require("./control_setting_tooltip_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/control_group_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlGroupEditor = ({
  onCancel,
  onSave,
  onDeleteAll,
  stateManager,
  api
}) => {
  const [children, selectedLabelPosition, selectedChainingSystem, selectedAutoApplySelections, selectedIgnoreParentSettings] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.children$, stateManager.api.labelPosition$, stateManager.api.chainingSystem$, stateManager.api.autoApplySelections$, stateManager.api.ignoreParentSettings$);
  const controlCount = (0, _react.useMemo)(() => Object.keys(children).length, [children]);
  const updateIgnoreSetting = (0, _react.useCallback)(newSettings => {
    stateManager.api.setIgnoreParentSettings({
      ...(selectedIgnoreParentSettings !== null && selectedIgnoreParentSettings !== void 0 ? selectedIgnoreParentSettings : {}),
      ...newSettings
    });
  }, [stateManager.api, selectedIgnoreParentSettings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, _control_group_strings.ControlGroupStrings.management.getFlyoutTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-group-settings-flyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    options: _editor_constants.CONTROL_LAYOUT_OPTIONS,
    "data-test-subj": "control-group-layout-options",
    idSelected: selectedLabelPosition,
    legend: _control_group_strings.ControlGroupStrings.management.labelPosition.getLabelPositionLegend(),
    onChange: newPosition => {
      stateManager.api.setLabelPosition(newPosition);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getFilteringSettingsTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-filter-sync",
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getUseGlobalFiltersTitle(),
    onChange: e => updateIgnoreSetting({
      ignoreFilters: !e.target.checked,
      ignoreQuery: !e.target.checked
    }),
    checked: !Boolean(selectedIgnoreParentSettings === null || selectedIgnoreParentSettings === void 0 ? void 0 : selectedIgnoreParentSettings.ignoreFilters) || !Boolean(selectedIgnoreParentSettings === null || selectedIgnoreParentSettings === void 0 ? void 0 : selectedIgnoreParentSettings.ignoreQuery),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-query-sync-time-range",
    label: _control_group_strings.ControlGroupStrings.management.filteringSettings.getUseGlobalTimeRangeTitle(),
    onChange: e => updateIgnoreSetting({
      ignoreTimerange: !e.target.checked
    }),
    checked: !Boolean(selectedIgnoreParentSettings === null || selectedIgnoreParentSettings === void 0 ? void 0 : selectedIgnoreParentSettings.ignoreTimerange),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.management.selectionSettings.getSelectionSettingsTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-validate-selections",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.validateSelections.getValidateSelectionsTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.validateSelections.getValidateSelectionsTooltip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 19
      }
    }),
    checked: !Boolean(selectedIgnoreParentSettings === null || selectedIgnoreParentSettings === void 0 ? void 0 : selectedIgnoreParentSettings.ignoreValidations),
    onChange: e => updateIgnoreSetting({
      ignoreValidations: !e.target.checked
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-chaining",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.controlChaining.getHierarchyTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.controlChaining.getHierarchyTooltip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }),
    checked: selectedChainingSystem === 'HIERARCHICAL',
    onChange: e => stateManager.api.setChainingSystem(e.target.checked ? 'HIERARCHICAL' : 'NONE'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "control-group-auto-apply-selections",
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _control_group_strings.ControlGroupStrings.management.selectionSettings.showApplySelections.getShowApplySelectionsTitle(),
      tooltip: _control_group_strings.ControlGroupStrings.management.selectionSettings.showApplySelections.getShowApplySelectionsTooltip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 19
      }
    }),
    checked: selectedAutoApplySelections,
    onChange: e => stateManager.api.setAutoApplySelections(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }))), controlCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDeleteAll,
    "data-test-subj": "delete-all-controls-button",
    "aria-label": 'delete-all',
    iconType: "trash",
    color: "danger",
    flush: "left",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, _control_group_strings.ControlGroupStrings.management.getDeleteAllButtonTitle()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-editing-group`,
    flush: "left",
    onClick: () => {
      onCancel();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }, _control_group_strings.ControlGroupStrings.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-group`,
    fill: true,
    color: "primary",
    "data-test-subj": "control-group-editor-save",
    onClick: () => {
      onSave();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, _control_group_strings.ControlGroupStrings.getSaveChangesTitle())))));
};
exports.ControlGroupEditor = ControlGroupEditor;