"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulePanel = exports.ConnectorScheduling = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _update_connector_scheduling_api_logic = require("../../../api/connector/update_connector_scheduling_api_logic");
var _routes = require("../../routes");
var _connector_detail = require("../../connector_detail/connector_detail");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _api = require("../../../../common/types/api");
var _encode_path_params = require("../../shared/encode_path_params");
var _app_context = require("../../../app_context");
var _unsaved_changes_prompt = require("../../shared/unsaved_changes_prompt");
var _react_router_helpers = require("../../shared/react_router_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/connector_scheduling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchedulePanel = ({
  title,
  description,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }), children)));
};
exports.SchedulePanel = SchedulePanel;
const ConnectorScheduling = () => {
  const {
    services: {
      application,
      http
    }
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    connector,
    hasDocumentLevelSecurityFeature,
    hasIncrementalSyncFeature
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    status
  } = (0, _kea.useValues)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const [hasChanges, setHasChanges] = (0, _react.useState)(false);
  const {
    hasPlatinumLicense
  } = (0, _app_context.useAppContext)();
  const shouldShowIncrementalSync = hasIncrementalSyncFeature;
  const shouldShowAccessControlSync = hasDocumentLevelSecurityFeature;
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: hasChanges,
    messageText: _i18n.i18n.translate('xpack.contentConnectors.content.indices.connectorScheduling.unsaved.title', {
      defaultMessage: 'You have not saved your changes, are you sure you want to leave?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorSchedulingComponent, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.contentConnectors.content.indices.connectorScheduling.page.description",
      defaultMessage: "Your connector is now deployed. Schedule recurring content and access control syncs here. If you want to run a quick test, launch a one-time sync using the {sync} button.",
      values: {
        sync: /*#__PURE__*/_react.default.createElement("b", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 23
          }
        }, _i18n.i18n.translate('xpack.contentConnectors.content.indices.connectorScheduling.page.sync.label', {
          defaultMessage: 'Sync'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    })),
    connector: connector,
    configurationPathOnClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _react_router_helpers.generateReactRouterProps)({
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      }),
      http,
      navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl,
      history: history
    }).href),
    dataTelemetryIdPrefix: "entSearchContent",
    hasChanges: hasChanges,
    hasIngestionError: connector.status === _searchConnectors.ConnectorStatus.ERROR,
    hasPlatinumLicense: hasPlatinumLicense,
    setHasChanges: setHasChanges,
    shouldShowAccessControlSync: shouldShowAccessControlSync,
    shouldShowIncrementalSync: shouldShowIncrementalSync,
    updateConnectorStatus: status === _api.Status.LOADING,
    updateScheduling: scheduling => makeRequest({
      connectorId: connector.id,
      scheduling,
      http
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.ConnectorScheduling = ConnectorScheduling;