"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _language_selector_modal = require("./language_selector_modal");
var _services = require("../../../../../services");
var _contexts = require("../../../../contexts");
var _constants = require("../../../../../../common/constants");
var _keys = require("../../../../components/shortcuts_popover/keys");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/editor/components/context_menu/context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  // Remove the default underline on hover for the context menu items since it
  // will also be applied to the language selector button, and apply it only to
  // the text in the context menu item.
  button: (0, _react2.css)`
    &:hover {
      text-decoration: none !important;

      /* Target the language selector when the button is hovered */
      .consoleEditorContextMenu__languageSelector {
        text-decoration: underline;
      }
    }
  `
};
const DELAY_FOR_HIDING_SPINNER = 500;
const getLanguageLabelByValue = value => {
  var _AVAILABLE_LANGUAGES$;
  return ((_AVAILABLE_LANGUAGES$ = _constants.AVAILABLE_LANGUAGES.find(lang => lang.value === value)) === null || _AVAILABLE_LANGUAGES$ === void 0 ? void 0 : _AVAILABLE_LANGUAGES$.label) || _constants.DEFAULT_LANGUAGE;
};
const ContextMenu = ({
  getRequests,
  getDocumentation,
  autoIndent,
  notifications,
  getIsKbnRequestSelected
}) => {
  var _window$navigator2;
  // Get default language from local storage
  const {
    services: {
      storage,
      esHostService
    },
    config: {
      isPackagedEnvironment
    }
  } = (0, _contexts.useServicesContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isRequestConverterLoading, setRequestConverterLoading] = (0, _react.useState)(false);
  const [isLanguageSelectorVisible, setLanguageSelectorVisibility] = (0, _react.useState)(false);
  const [isKbnRequestSelected, setIsKbnRequestSelected] = (0, _react.useState)(null);
  const [defaultLanguage, setDefaultLanguage] = (0, _react.useState)(storage.get(_services.StorageKeys.DEFAULT_LANGUAGE, _constants.DEFAULT_LANGUAGE));
  const [currentLanguage, setCurrentLanguage] = (0, _react.useState)(defaultLanguage);
  (0, _react.useEffect)(() => {
    if (isKbnRequestSelected) {
      setCurrentLanguage(_constants.DEFAULT_LANGUAGE);
    } else {
      setCurrentLanguage(defaultLanguage);
    }
  }, [defaultLanguage, isKbnRequestSelected]);
  const copyText = async text => {
    var _window$navigator;
    if ((_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.clipboard) {
      await window.navigator.clipboard.writeText(text);
      return;
    }
    throw new Error('Could not copy to clipboard!');
  };

  // This function will convert all the selected requests to the language by
  // calling convertRequestToLanguage and then copy the data to clipboard.
  const copyAs = async language => {
    // Get the language we want to convert the requests to
    const withLanguage = language || currentLanguage;
    // Get all the selected requests
    const requests = await getRequests();

    // If we have any kbn requests, we should not allow the user to copy as
    // anything other than curl
    const hasKbnRequests = requests.some(req => req.url.startsWith(_constants.KIBANA_API_PREFIX));
    if (hasKbnRequests && withLanguage !== 'curl') {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('console.consoleMenu.copyAsMixedRequestsMessage', {
          defaultMessage: 'Kibana requests can only be copied as curl'
        })
      });
      return;
    }
    const {
      data: requestsAsCode,
      error: requestError
    } = await (0, _services.convertRequestToLanguage)({
      language: withLanguage,
      esHost: esHostService.getHost(),
      kibanaHost: window.location.origin,
      requests
    });
    if (requestError) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('console.consoleMenu.copyAsFailedMessage', {
          defaultMessage: '{requestsCount, plural, one {Request} other {Requests}} could not be copied to clipboard',
          values: {
            requestsCount: requests.length
          }
        })
      });
      return;
    }
    notifications.toasts.addSuccess({
      title: _i18n.i18n.translate('console.consoleMenu.copyAsSuccessMessage', {
        defaultMessage: '{requestsCount, plural, one {Request} other {Requests}} copied to clipboard as {language}',
        values: {
          language: getLanguageLabelByValue(withLanguage),
          requestsCount: requests.length
        }
      })
    });
    await copyText(requestsAsCode);
  };
  const checkIsKbnRequestSelected = async () => {
    setIsKbnRequestSelected(await getIsKbnRequestSelected());
  };
  const onCopyAsSubmit = async language => {
    const withLanguage = language || currentLanguage;

    // Close language selector modal
    setLanguageSelectorVisibility(false);
    // Show loading spinner
    setRequestConverterLoading(true);

    // When copying as worked as expected, close the context menu popover
    copyAs(withLanguage).then(() => {
      setIsPopoverOpen(false);
    }).finally(() => {
      // Delay hiding the spinner to avoid flickering between the spinner and
      // the change language button
      setTimeout(() => {
        setRequestConverterLoading(false);
      }, DELAY_FOR_HIDING_SPINNER);
    });
  };
  const changeDefaultLanguage = language => {
    if (currentLanguage !== language) {
      storage.set(_services.StorageKeys.DEFAULT_LANGUAGE, language);
    }
    setDefaultLanguage(language);
    if (!isKbnRequestSelected) {
      setCurrentLanguage(language);
    }
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const openDocs = async () => {
    closePopover();
    const documentation = await getDocumentation();
    if (!documentation) {
      notifications.toasts.addWarning({
        title: _i18n.i18n.translate('console.consoleMenu.missingDocumentationPage', {
          defaultMessage: 'Documentation page is not yet available for this API.'
        })
      });
      return;
    }
    window.open(documentation, '_blank');
  };
  const handleAutoIndent = event => {
    closePopover();
    autoIndent(event);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      setIsPopoverOpen(prev => !prev);
      checkIsKbnRequestSelected();
    },
    "data-test-subj": "toggleConsoleMenu",
    "aria-label": _i18n.i18n.translate('console.requestOptionsButtonAriaLabel', {
      defaultMessage: 'Request options'
    }),
    iconType: "boxesVertical",
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 5
    }
  });
  const items = [...(!isPackagedEnvironment ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Copy to",
    "data-test-subj": "consoleMenuCopyAsButton",
    id: "copyAs",
    disabled: !((_window$navigator2 = window.navigator) !== null && _window$navigator2 !== void 0 && _window$navigator2.clipboard),
    onClick: () => onCopyAsSubmit(),
    icon: "copyClipboard",
    css: styles.button,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    className: "consoleEditorContextMenu__languageSelector",
    "data-test-subj": "language-selector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "span",
    id: "console.monaco.requestOptions.copyAsUrlButtonLabel",
    defaultMessage: "Copy to",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 17
    }
  }, getLanguageLabelByValue(currentLanguage)))))] : []), ...(!isPackagedEnvironment && !isKbnRequestSelected ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Select language",
    "data-test-subj": "consoleMenuSelectLanguage",
    id: "selectLanguage",
    onClick: () => setLanguageSelectorVisibility(true),
    icon: "editorCodeBlock",
    disabled: isRequestConverterLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.monaco.requestOptions.selectLanguageButtonLabel",
    defaultMessage: "Select language",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 17
    }
  })), isRequestConverterLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 19
    }
  }))))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "consoleMenuAutoIndent",
    key: "Auto indent",
    onClick: handleAutoIndent,
    icon: "kqlFunction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.monaco.requestOptions.autoIndentButtonLabel",
    defaultMessage: "Auto indent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "consoleMenuAutoIndentShortcut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }, _keys.KEYS.keyCtrlCmd), " + ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 52
    }
  }, _keys.KEYS.keyI))))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Open documentation",
    "data-test-subj": "consoleMenuOpenDocs",
    onClick: openDocs,
    icon: "documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.monaco.requestOptions.openDocumentationButtonLabel",
    defaultMessage: "Open API reference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "consoleMenuOpenDocsShortcut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  }, _keys.KEYS.keyCtrlCmd), " + ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 52
    }
  }, _keys.KEYS.keySlash)))))];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenu",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "consoleMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 9
    }
  })), isLanguageSelectorVisible && /*#__PURE__*/_react.default.createElement(_language_selector_modal.LanguageSelectorModal, {
    currentLanguage: currentLanguage,
    changeDefaultLanguage: changeDefaultLanguage,
    closeModal: () => setLanguageSelectorVisibility(false),
    onSubmit: onCopyAsSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }));
};
exports.ContextMenu = ContextMenu;