"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleTourStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/components/console_tour_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConsoleTourStep = ({
  tourStepProps,
  children
}) => {
  const {
    step,
    isStepOpen,
    stepsTotal,
    title,
    content,
    onFinish,
    footerAction,
    dataTestSubj,
    anchorPosition,
    maxWidth,
    css
  } = tourStepProps;
  const [popoverVisible, setPopoverVisible] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let timeoutId;
    if (isStepOpen) {
      timeoutId = setTimeout(() => {
        setPopoverVisible(true);
      }, _constants.WELCOME_TOUR_DELAY);
    } else {
      setPopoverVisible(false);
    }
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [isStepOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    step: step,
    stepsTotal: stepsTotal,
    isStepOpen: popoverVisible,
    title: title,
    content: content,
    onFinish: onFinish,
    footerAction: footerAction,
    "data-test-subj": dataTestSubj,
    anchorPosition: anchorPosition,
    maxWidth: maxWidth,
    css: css,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, children);
};
exports.ConsoleTourStep = ConsoleTourStep;