"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OneConsole = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _coreDocLinksBrowserInternal = require("@kbn/core-doc-links-browser-internal");
var _coreHttpBrowserInternal = require("@kbn/core-http-browser-internal");
var _coreExecutionContextBrowserInternal = require("@kbn/core-execution-context-browser-internal");
var _coreFatalErrorsBrowserInternal = require("@kbn/core-fatal-errors-browser-internal");
var _coreAnalyticsBrowserInternal = require("@kbn/core-analytics-browser-internal");
var _coreThemeBrowserInternal = require("@kbn/core-theme-browser-internal");
var _coreI18nBrowserInternal = require("@kbn/core-i18n-browser-internal");
var _i18n = require("@kbn/i18n");
var _services = require("../../public/services");
var _kb = require("../../public/lib/kb");
var _parser = require("./parser");
var _services2 = require("./services");
var localStorageObjectClient = _interopRequireWildcard(require("../../public/lib/local_storage_object_client"));
var _containers = require("../../public/application/containers");
var _contexts = require("../../public/application/contexts");
var _lib = require("../../public/application/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/packaging/react/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// This is a packaged standalone version of console that needs to import browser code
/* eslint-disable @kbn/imports/no_boundary_crossing */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Disable Monaco workers entirely, in case monaco ever decides to spawn any for some reason.
// Console doesnt use any of the monaco features that require workers, since we provide
// our own language tokenizer and autocompletion provider.
window.MonacoEnvironment = {
  getWorker() {
    // Return a minimal mock worker that doesn't actually do anything
    return {
      postMessage: () => {},
      addEventListener: () => {},
      removeEventListener: () => {},
      terminate: () => {},
      onerror: null,
      onmessage: null,
      onmessageerror: null
    };
  }
};
// Translation files are generated during the build process
/* eslint-disable @kbn/imports/no_unresolvable_imports */
const translations = {
  en: {
    formats: {},
    messages: {}
  },
  'fr-FR': require('./translations/fr-FR.json'),
  'ja-JP': require('./translations/ja-JP.json'),
  'zh-CN': require('./translations/zh-CN.json'),
  'de-DE': require('./translations/de-DE.json')
};
/* eslint-enable @kbn/imports/no_unresolvable_imports */

const OneConsole = ({
  lang = 'en',
  http: customHttp,
  notifications: customNotifications
}) => {
  const [apiLoaded, setApiLoaded] = (0, _react.useState)(false);

  // Get the translations for the selected language, fallback to English
  const selectedTranslations = translations[lang] || translations.en;

  // Configure the global @kbn/i18n system with the same translations
  _i18n.i18n.init({
    locale: lang,
    formats: selectedTranslations.formats,
    messages: selectedTranslations.messages
  });

  // Create all services once using useRef as they should never be recreated
  const servicesRef = (0, _react.useRef)(null);
  if (!servicesRef.current) {
    const docLinksService = new _coreDocLinksBrowserInternal.DocLinksService(_services2.coreContext);
    docLinksService.setup();
    const docLinks = docLinksService.start({
      injectedMetadata: _services2.injectedMetadata
    });
    const i18nService = new _coreI18nBrowserInternal.I18nService();
    const themeService = new _coreThemeBrowserInternal.ThemeService();
    const theme = themeService.setup({
      injectedMetadata: _services2.injectedMetadata
    });
    const analyticsService = new _coreAnalyticsBrowserInternal.AnalyticsService(_services2.coreContext);
    const analytics = analyticsService.setup({
      injectedMetadata: _services2.injectedMetadata
    });
    const rootDomElement = document.getElementById('root');
    const fatalErrorsService = new _coreFatalErrorsBrowserInternal.FatalErrorsService(rootDomElement, () => {
      // eslint-disable-next-line no-console
      console.log('FATAL ERROR OCURRED');
    });
    const fatalErrors = fatalErrorsService.setup({
      injectedMetadata: _services2.injectedMetadata,
      analytics,
      theme,
      i18n: i18nService.getContext()
    });
    const executionContextService = new _coreExecutionContextBrowserInternal.ExecutionContextService();
    const executionContext = executionContextService.setup({
      analytics
    });
    const httpService = new _coreHttpBrowserInternal.HttpService();
    const originalHttp = httpService.setup({
      injectedMetadata: _services2.injectedMetadata,
      fatalErrors,
      executionContext
    });
    const http = {
      ...originalHttp,
      ...customHttp
    };
    const storage = (0, _services.createStorage)({
      engine: window.localStorage,
      prefix: 'sense:'
    });
    (0, _services.setStorage)(storage);
    const storageHistory = (0, _services.createHistory)({
      storage
    });
    const settings = (0, _services.createSettings)({
      storage
    });
    const objectStorageClient = localStorageObjectClient.create(storage);
    const api = (0, _lib.createApi)({
      http
    });
    const esHostService = (0, _lib.createEsHostService)({
      api
    });

    // Initialize autocompleteInfo like in the plugin
    const autocompleteInfo = new _services.AutocompleteInfo();
    autocompleteInfo.setup(http);
    autocompleteInfo.mapping.setup(http, settings);
    // Initialize autocomplete
    (0, _services.setAutocompleteInfo)(autocompleteInfo);
    servicesRef.current = {
      http,
      docLinks,
      theme,
      i18nService,
      storage,
      storageHistory,
      settings,
      objectStorageClient,
      esHostService,
      autocompleteInfo
    };
  }
  const {
    http,
    docLinks,
    theme,
    i18nService,
    storage,
    storageHistory,
    settings,
    objectStorageClient,
    esHostService,
    autocompleteInfo
  } = servicesRef.current;

  // Use the custom notifications provided by the consumer
  const notifications = (0, _react.useMemo)(() => ({
    toasts: {
      addSuccess: customNotifications.addSuccess || _lodash.noop,
      addWarning: customNotifications.addWarning || _lodash.noop,
      addDanger: customNotifications.addDanger || _lodash.noop,
      addError: customNotifications.addError || _lodash.noop,
      add: customNotifications.add || _lodash.noop,
      remove: customNotifications.remove || _lodash.noop
    }
  }), [customNotifications]);
  (0, _react.useEffect)(() => {
    const loadApi = async () => {
      try {
        await (0, _kb.loadActiveApi)(http);
        setApiLoaded(true);
      } catch (error) {
        setApiLoaded(true);
      }
    };
    loadApi();
  }, [http]);

  // Don't render until API is loaded
  if (!apiLoaded) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, {
    locale: lang,
    messages: selectedTranslations.messages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.ServicesContextProvider, {
    value: {
      analytics: {
        reportEvent: () => {}
      },
      i18n: i18nService.getContext(),
      theme: {
        theme$: theme.theme$
      },
      userProfile: {
        getUserProfile$: () => ({
          pipe: () => ({
            subscribe: () => {}
          })
        }),
        userProfile: null
      },
      docLinkVersion: docLinks.DOC_LINK_VERSION,
      docLinks: docLinks.links,
      services: {
        esHostService,
        storage,
        history: storageHistory,
        settings,
        notifications: notifications,
        trackUiMetric: _services2.trackUiMetric,
        objectStorageClient,
        http,
        autocompleteInfo,
        data: {},
        licensing: {},
        application: {}
      },
      config: {
        isDevMode: false,
        isPackagedEnvironment: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.RequestContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.EditorContextProvider, {
    settings: settings.toJSON(),
    customParsedRequestsProvider: (0, _parser.createPackagingParsedRequestsProvider)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnConsole",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_containers.Main, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  }))))));
};
exports.OneConsole = OneConsole;