"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSecretsSchemaFromSpec = void 0;
var _v = require("@kbn/zod/v4");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generateSecretsSchemaFromSpec = authSpec => {
  const secretSchemas = [];
  for (const authType of (authSpec === null || authSpec === void 0 ? void 0 : authSpec.types) || []) {
    secretSchemas.push((0, _.getSchemaForAuthType)(authType));
  }
  return secretSchemas.length > 0 ?
  // to make zod types happy
  _v.z.discriminatedUnion('authType', [secretSchemas[0], ...secretSchemas.slice(1)]).meta({
    label: 'Authentication'
  }) : _v.z.object({});
};
exports.generateSecretsSchemaFromSpec = generateSecretsSchemaFromSpec;