"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityOverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _fp = require("lodash/fp");
var _helpers = require("@kbn/cloud-security-posture/src/utils/helpers");
var _nvd_logo_svg = require("../../../assets/icons/nvd_logo_svg");
var _get_vector_score_list = require("../utils/get_vector_score_list");
var _redhat_logo = _interopRequireDefault(require("../../../assets/icons/redhat_logo.svg"));
var _vulnerability_detection_rule_counter = require("./vulnerability_detection_rule_counter");
var _copy_button = require("../../../components/copy_button");
var _overview_tab = require("../../configurations/findings_flyout/overview_tab");
var _vulnerability_id_content = require("./vulnerability_id_content");
var _test_subjects = require("../test_subjects");
var _vulnerability_description_section = require("./vulnerability_description_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const cvssVendors = {
  nvd: 'NVD',
  redhat: 'Red Hat',
  ghsa: 'GHSA'
};
const vendorIcons = {
  redhat: _redhat_logo.default,
  ghsa: 'logoGithub'
};
const EMPTY_VALUE = '-';
const CVSScore = ({
  vectorBaseScore,
  vendor
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const vendorName = cvssVendors[vendor];
  const vectorScores = (0, _get_vector_score_list.getVectorScoreList)(vectorBaseScore);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        border: 1px solid ${euiTheme.border.color};
        border-radius: 6px;
        padding: ${euiTheme.size.m};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
          width: 116px;
          font-weight: 600;
          display: flex;
          flex-direction: row;
          align-items: center;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
            margin-right: 30px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, vendor === 'nvd' ? (0, _nvd_logo_svg.NvdLogo)() : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: vendorIcons[vendor],
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 43
    }
  })), /*#__PURE__*/_react2.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, vendorName)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, vectorScores.length > 0 && vectorScores.map((vectorScore, i) => /*#__PURE__*/_react2.default.createElement(VectorScore, {
    key: `${vectorScore}-${i}`,
    vectorScore: vectorScore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }))));
};
const VectorScore = ({
  vectorScore
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    score,
    vector,
    version
  } = vectorScore;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          background: ${euiTheme.colors.backgroundLightText};
          padding: ${euiTheme.size.xs} ${euiTheme.size.s};
          border-radius: 6px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-size: ${euiTheme.size.m};
              color: ${euiTheme.colors.textParagraph};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, vector, ' ')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, score && /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    score: score,
    version: version,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 21
    }
  }))));
};
const emptyFixesMessageState = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityOverviewTab.emptyFixesMessage', {
  defaultMessage: 'No available fixes yet.'
});

/**
 * Component to display reference links with copy buttons and external link icons
 */

const ReferenceLinks = ({
  references
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, references.map((ref, index) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: `reference-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: ref,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, ref))));
};
const renderFixedBySection = (vulnerabilityRecord, euiTheme) => {
  var _vulnerabilityRecord$;
  const renderFinding = (item, i, field, object) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react.css)`
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, item)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_copy_button.CopyButton, {
    copyText: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  })));
  const renderPackageField = field => {
    const value = (0, _fp.get)(field, vulnerabilityRecord);
    if (!value) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 14
        }
      }, EMPTY_VALUE);
    }
    return Array.isArray(value) ? /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: value,
      field: `package.${field}`,
      object: vulnerabilityRecord,
      renderItem: renderFinding,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 7
      }
    }) : value;
  };
  if (!(vulnerabilityRecord !== null && vulnerabilityRecord !== void 0 && (_vulnerabilityRecord$ = vulnerabilityRecord.package) !== null && _vulnerabilityRecord$ !== void 0 && _vulnerabilityRecord$.fixed_version)) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 12
      }
    }, emptyFixesMessageState);
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "flexStart",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.packageTitle",
    defaultMessage: "Package",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, renderPackageField('package.name')))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      marginBottom: euiTheme.size.xxs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    css: (0, _react.css)`
                  font-weight: ${euiTheme.font.weight.medium};
                `,
    id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.versionTitle",
    defaultMessage: "Version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 11
    }
  }, renderPackageField('package.fixed_version')))));
};
const getVulnerabilityScoreList = vulnerabilityData => {
  var _renderCvssScores;
  return [{
    title: '',
    description: vulnerabilityData ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l",
      css: (0, _react.css)`
          margin-top: '4px'};
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 7
      }
    }, !!((_renderCvssScores = renderCvssScores(vulnerabilityData.vulnerability)) !== null && _renderCvssScores !== void 0 && _renderCvssScores.length) ? renderCvssScores(vulnerabilityData.vulnerability) : EMPTY_VALUE) : EMPTY_VALUE
  }];
};
const getResourceList = vulnerabilityData => {
  var _vulnerabilityData$re, _vulnerabilityData$re2, _vulnerabilityData$pa, _vulnerabilityData$pa2;
  return [{
    title: '',
    description: vulnerabilityData ? /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBasicTable, {
      "data-test-subj": _test_subjects.VULNERABILITY_RESOURCE_TABLE,
      items: (0, _overview_tab.convertObjectToArray)({
        ID: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$re = vulnerabilityData.resource) === null || _vulnerabilityData$re === void 0 ? void 0 : _vulnerabilityData$re.id,
        Name: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$re2 = vulnerabilityData.resource) === null || _vulnerabilityData$re2 === void 0 ? void 0 : _vulnerabilityData$re2.name,
        Package: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$pa = vulnerabilityData.package) === null || _vulnerabilityData$pa === void 0 ? void 0 : _vulnerabilityData$pa.name,
        Version: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$pa2 = vulnerabilityData.package) === null || _vulnerabilityData$pa2 === void 0 ? void 0 : _vulnerabilityData$pa2.version
      }) || [],
      rowHeader: "Field",
      columns: _overview_tab.columns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 11
      }
    }))) : EMPTY_VALUE
  }];
};
const getDetailsList = (vulnerabilityData, euiTheme) => {
  var _vulnerabilityData$vu, _vulnerabilityData$vu2, _vulnerabilityData$vu3;
  const detailsList = [{
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.alertsTitle', {
      defaultMessage: 'Alerts'
    }))),
    description: (_vulnerabilityData$vu = vulnerabilityData.vulnerability) !== null && _vulnerabilityData$vu !== void 0 && _vulnerabilityData$vu.id ? /*#__PURE__*/_react2.default.createElement(_vulnerability_detection_rule_counter.VulnerabilityDetectionRuleCounter, {
      vulnerabilityRecord: vulnerabilityData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 9
      }
    }) : EMPTY_VALUE
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.cveTitle', {
      defaultMessage: 'CVE'
    }))),
    description: /*#__PURE__*/_react2.default.createElement(_vulnerability_id_content.VulnerabilityIdContent, {
      vulnerability: vulnerabilityData.vulnerability,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 20
      }
    })
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.publishedTitle', {
      defaultMessage: 'Published'
    }))),
    description: (_vulnerabilityData$vu2 = vulnerabilityData.vulnerability) !== null && _vulnerabilityData$vu2 !== void 0 && _vulnerabilityData$vu2.published_date ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.publishedDateText",
      defaultMessage: "{date}",
      values: {
        date: vulnerabilityData.vulnerability.published_date
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 9
      }
    }) : EMPTY_VALUE
  }];
  const nonCveReferences = (0, _cloudSecurityPosture.getNonCveReferences)(vulnerabilityData);
  if (nonCveReferences.length > 0) {
    detailsList.push({
      title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
        size: "xxs",
        css: {
          marginBottom: euiTheme.size.xs
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 406,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.referencesTitle', {
        defaultMessage: 'References'
      }))),
      description: /*#__PURE__*/_react2.default.createElement(ReferenceLinks, {
        references: nonCveReferences,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 417,
          columnNumber: 20
        }
      })
    });
  }
  detailsList.push({
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.descriptionTitle', {
      defaultMessage: 'Description'
    }))),
    description: /*#__PURE__*/_react2.default.createElement(_vulnerability_description_section.VulnerabilityDescriptionSection, {
      description: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$vu3 = vulnerabilityData.vulnerability) === null || _vulnerabilityData$vu3 === void 0 ? void 0 : _vulnerabilityData$vu3.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 7
      }
    })
  });
  detailsList.push({
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 443,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.fixedByTitle', {
      defaultMessage: 'Fixed by'
    }))),
    description: renderFixedBySection(vulnerabilityData, euiTheme)
  });
  return detailsList;
};
const renderCvssScores = vulnerability => {
  if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.cvss)) return [];
  return Object.entries(vulnerability.cvss).map(([vendor, vectorScoreBase]) => {
    if (cvssVendors[vendor]) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        key: vendor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 467,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(CVSScore, {
        vectorBaseScore: vectorScoreBase,
        vendor: vendor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 468,
          columnNumber: 13
        }
      }));
    }
    return null;
  }).filter(Boolean); // Filter out any `undefined` values
};
const VulnerabilityOverviewTab = ({
  vulnerabilityRecord
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.VULNERABILITIES_FLYOUT_VISITS);
  const accordions = (0, _react2.useMemo)(() => [{
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.aboutTitle', {
      defaultMessage: 'About'
    }),
    id: 'detailsAccordion',
    listItems: getDetailsList(vulnerabilityRecord, euiTheme)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.resourceTitle', {
      defaultMessage: 'Resource'
    }),
    id: 'resourceAccordion',
    listItems: getResourceList(vulnerabilityRecord)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.vulnerabilityScoreTitle', {
      defaultMessage: 'Vulnerability Score'
    }),
    id: 'vulnerabilityScoreAccordion',
    listItems: getVulnerabilityScoreList(vulnerabilityRecord)
  }].filter(_helpers.truthy), [euiTheme, vulnerabilityRecord]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, accordions.map(accordion => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
    key: accordion.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 524,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: accordion.id,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 528,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 17
      }
    }, accordion.title)),
    arrowDisplay: "left",
    initialIsOpen: accordion.initialIsOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m",
    listItems: accordion.listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 11
    }
  }))));
};
exports.VulnerabilityOverviewTab = VulnerabilityOverviewTab;