"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspInlineDescriptionList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _copy_button = require("./copy_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/csp_inline_description_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getModifiedTitlesListItems = listItems => listItems === null || listItems === void 0 ? void 0 : listItems.filter(item => !!(item !== null && item !== void 0 && item.title) && !!(item !== null && item !== void 0 && item.description)).map(item => ({
  ...item,
  title: `${item.title}:`,
  description: typeof item.description === 'string' ? /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 11
    }
  }, item.description, " ", /*#__PURE__*/_react.default.createElement(_copy_button.CopyButton, {
    copyText: item.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 32
    }
  })) : item.description
}));

// eui size m is 12px which is too small, and next after it is base which is 16px which is too big
const fontSize = '1rem';
const CspInlineDescriptionList = ({
  testId,
  listItems
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modifiedTitlesListItems = getModifiedTitlesListItems(listItems);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": testId,
    type: "inline",
    titleProps: {
      style: {
        background: 'initial',
        color: euiTheme.colors.textSubdued,
        fontSize,
        paddingRight: 0,
        paddingInline: 0,
        marginInline: 'unset',
        marginInlineEnd: euiTheme.size.xs
      }
    },
    descriptionProps: {
      style: {
        color: euiTheme.colors.textSubdued,
        marginRight: euiTheme.size.xs,
        fontSize
      }
    },
    listItems: modifiedTitlesListItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.CspInlineDescriptionList = CspInlineDescriptionList;