"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspRoute = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../common/navigation/constants");
var _security_solution_context = require("./security_solution_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/application/csp_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Security SpyRoute can be automatically rendered for pages with static paths, Security will manage everything using the `links` object.
// Pages with dynamic paths are not in the Security `links` object, they must render SpyRoute with the parameters values, if needed.
const STATIC_PATH_PAGE_IDS = Object.fromEntries(Object.values(_constants.cloudPosturePages).map(({
  id
}) => [id, true]));
const CspRoute = ({
  id,
  children,
  component: Component,
  disabled = false,
  ...cspRouteProps
}) => {
  var _useSecuritySolutionC;
  const SpyRoute = (_useSecuritySolutionC = (0, _security_solution_context.useSecuritySolutionContext)()) === null || _useSecuritySolutionC === void 0 ? void 0 : _useSecuritySolutionC.getSpyRouteComponent();
  if (disabled) {
    return null;
  }
  const routeProps = {
    ...cspRouteProps,
    ...(Component && {
      render: renderProps => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
        viewId: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }, STATIC_PATH_PAGE_IDS[id] && SpyRoute && /*#__PURE__*/_react.default.createElement(SpyRoute, {
        pageName: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 52
        }
      }), /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, renderProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      })))
    })
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({}, routeProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 10
    }
  }), children);
};
exports.CspRoute = CspRoute;