"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteFiles = exports.createFileEntities = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pMap = _interopRequireDefault(require("p-map"));
var _files = require("../../../common/files");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFileEntities = files => {
  const fileEntities = [];

  // It's possible that the owner array could have invalid information in it so we'll use the file kind for determining if the user
  // has the correct authorization for deleting these files
  for (const fileInfo of files) {
    const ownerFromFileKind = (0, _files.constructOwnerFromFileKind)(fileInfo.fileKind);
    if (ownerFromFileKind == null) {
      throw _boom.default.badRequest(`File id ${fileInfo.id} has invalid file kind ${fileInfo.fileKind}`);
    }
    fileEntities.push({
      id: fileInfo.id,
      owner: ownerFromFileKind
    });
  }
  return fileEntities;
};
exports.createFileEntities = createFileEntities;
const deleteFiles = async (fileIds, fileService) => {
  if (fileIds.length <= 0) {
    return;
  }
  return (0, _pMap.default)(fileIds, async fileId => fileService.delete({
    id: fileId
  }), {
    concurrency: _constants.MAX_CONCURRENT_SEARCHES
  });
};
exports.deleteFiles = deleteFiles;