"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_DARK_MODE = exports.ActionWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("../../../../common");
var _kibana = require("../../../common/lib/kibana");
var _cases_context = _interopRequireDefault(require("../../cases_context"));
var _owner = require("../../../../common/utils/owner");
var _can_use_cases = require("../../../client/helpers/can_use_cases");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/visualizations/actions/action_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_DARK_MODE = exports.DEFAULT_DARK_MODE = 'theme:darkMode';
const ActionWrapperWithContext = ({
  children,
  casesActionContextProps,
  currentAppId
}) => {
  const {
    application,
    ...startServices
  } = (0, _kibana.useKibana)().services;
  const owner = (0, _owner.getCaseOwnerByAppId)(currentAppId);
  const casePermissions = (0, _can_use_cases.canUseCases)(application.capabilities)(owner ? [owner] : undefined);
  // TODO: Remove when https://github.com/elastic/kibana/issues/143201 is developed
  const syncAlerts = owner === _common.SECURITY_SOLUTION_OWNER;
  const extractObservables = owner === _common.SECURITY_SOLUTION_OWNER;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_cases_context.default, {
    value: {
      ...casesActionContextProps,
      owner: owner ? [owner] : [],
      permissions: casePermissions,
      features: {
        alerts: {
          sync: syncAlerts
        },
        observables: {
          enabled: true,
          autoExtract: extractObservables
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, children));
};
ActionWrapperWithContext.displayName = 'ActionWrapperWithContext';
const ActionWrapperComponent = ({
  casesActionContextProps,
  children,
  currentAppId,
  services
}) => {
  return /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      ...services.core,
      ...services.plugins,
      storage: services.storage
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: services.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ActionWrapperWithContext, {
    casesActionContextProps: casesActionContextProps,
    currentAppId: currentAppId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, children)));
};
ActionWrapperComponent.displayName = 'ActionWrapper';
const ActionWrapper = exports.ActionWrapper = /*#__PURE__*/_react.default.memo(ActionWrapperComponent);