"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleExperimentalBadge = exports.TitleBetaBadge = exports.Title = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _truncated_text = require("../truncated_text");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/header_page/title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExperimentalBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.EXPERIMENTAL_LABEL,
  tooltipContent: i18n.EXPERIMENTAL_DESC,
  tooltipPosition: "bottom",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 3
  }
});
ExperimentalBadge.displayName = 'ExperimentalBadge';
const TitleExperimentalBadge = exports.TitleExperimentalBadge = /*#__PURE__*/_react.default.memo(ExperimentalBadge);
const BetaBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.BETA_LABEL,
  tooltipContent: i18n.BETA_DESC,
  tooltipPosition: "bottom",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
});
BetaBadge.displayName = 'BetaBadge';
const TitleBetaBadge = exports.TitleBetaBadge = /*#__PURE__*/_react.default.memo(BetaBadge);
const TitleComponent = ({
  title,
  releasePhase,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "baseline",
  gutterSize: "s",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement("h1", {
  "data-test-subj": "header-page-title",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 13
  }
}, (0, _lodash.isString)(title) ? /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
  text: title,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 34
  }
}) : title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 9
  }
}, children))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}, releasePhase === 'experimental' && /*#__PURE__*/_react.default.createElement(ExperimentalBadge, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 43
  }
}), releasePhase === 'beta' && /*#__PURE__*/_react.default.createElement(BetaBadge, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 35
  }
})));
TitleComponent.displayName = 'Title';
const Title = exports.Title = /*#__PURE__*/_react.default.memo(TitleComponent);