"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _card = require("../card");
var _use_get_fields = require("./use_get_fields");
var _formatted_date = require("../../formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/resilient/case_fields_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResilientFieldsComponent = ({
  connector,
  fields
}) => {
  const {
    incidentTypes = null,
    severityCode = null,
    additionalFields = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingFields,
    isFetching: isFetchingFields,
    data: fieldsData
  } = (0, _use_get_fields.useGetFields)({
    http,
    connector
  });
  const allIncidentTypes = (0, _react.useMemo)(() => {
    var _fieldsData$data;
    const incidentTypesField = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data = fieldsData.data) === null || _fieldsData$data === void 0 ? void 0 : _fieldsData$data.fieldsObj.incident_type_ids;
    if (incidentTypesField == null || !Array.isArray(incidentTypesField.values)) {
      return [];
    } else {
      return incidentTypesField.values;
    }
  }, [fieldsData]);
  const severity = (0, _react.useMemo)(() => {
    var _fieldsData$data2;
    const severityField = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data2 = fieldsData.data) === null || _fieldsData$data2 === void 0 ? void 0 : _fieldsData$data2.fieldsObj.severity_code;
    if (severityField == null || !Array.isArray(severityField.values)) {
      return [];
    } else {
      return severityField.values;
    }
  }, [fieldsData]);
  const isLoading = isLoadingFields || isFetchingFields;
  const listItems = (0, _react.useMemo)(() => {
    var _severity$find$label, _severity$find;
    let additionalFieldsParsed = {};
    try {
      additionalFieldsParsed = additionalFields ? JSON.parse(additionalFields) : {};
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error('Error parsing additional fields:', error, {
        additionalFields
      });
    }
    return [...(incidentTypes != null && incidentTypes.length > 0 ? [{
      title: i18n.INCIDENT_TYPES_LABEL,
      description: (allIncidentTypes !== null && allIncidentTypes !== void 0 ? allIncidentTypes : []).filter(type => incidentTypes.includes(type.value.toString())).map(type => type.label).join(', ')
    }] : []), ...(severityCode != null && severityCode.length > 0 ? [{
      title: i18n.SEVERITY_LABEL,
      description: (_severity$find$label = severity === null || severity === void 0 ? void 0 : (_severity$find = severity.find(severityObj => severityObj.value.toString() === severityCode)) === null || _severity$find === void 0 ? void 0 : _severity$find.label) !== null && _severity$find$label !== void 0 ? _severity$find$label : ''
    }] : []), ...(additionalFields != null && additionalFields.length > 0 ? Object.keys(additionalFieldsParsed).map(key => {
      var _fieldsData$data$fiel, _fieldsData$data3, _fieldsData$data3$fie, _fieldsData$data4;
      return {
        title: (_fieldsData$data$fiel = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data3 = fieldsData.data) === null || _fieldsData$data3 === void 0 ? void 0 : (_fieldsData$data3$fie = _fieldsData$data3.fieldsObj[key]) === null || _fieldsData$data3$fie === void 0 ? void 0 : _fieldsData$data3$fie.text) !== null && _fieldsData$data$fiel !== void 0 ? _fieldsData$data$fiel : key,
        description: renderAddtionalFieldsDescription(fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data4 = fieldsData.data) === null || _fieldsData$data4 === void 0 ? void 0 : _fieldsData$data4.fieldsObj[key], additionalFieldsParsed[key])
      };
    }) : [])];
  }, [incidentTypes, severityCode, allIncidentTypes, severity, additionalFields, fieldsData]);
  return /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.resilient,
    isLoading: isLoading,
    listItems: listItems,
    title: connector.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  });
};
exports.default = ResilientFieldsComponent;
function renderAddtionalFieldsDescription(fieldMetaData, fieldValue) {
  if (!fieldMetaData) {
    return fieldValue;
  }
  switch (fieldMetaData.input_type) {
    case 'boolean':
      return typeof fieldValue === 'boolean' ? fieldValue ? 'true' : 'false' : '';
    case 'number':
      return typeof fieldValue === 'number' ? fieldValue.toString() : '';
    case 'datepicker':
      return typeof fieldValue === 'number' ? /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
        dateFormat: "MMMM D, YYYY",
        value: new Date(fieldValue),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 9
        }
      }) : fieldValue;
    case 'datetimepicker':
      return typeof fieldValue === 'number' ? /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
        dateFormat: "MMMM D, YYYY @ HH:mm:ss",
        value: new Date(fieldValue),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 9
        }
      }) : fieldValue;
    case 'select':
      {
        var _fieldMetaData$values;
        const option = fieldValue && ((_fieldMetaData$values = fieldMetaData.values) === null || _fieldMetaData$values === void 0 ? void 0 : _fieldMetaData$values.find(item => item.value.toString() === fieldValue.toString()));
        return option ? option.label : fieldValue;
      }
    case 'multiselect':
      {
        return Array.isArray(fieldValue) && fieldMetaData !== null && fieldMetaData !== void 0 && fieldMetaData.values ? fieldValue.map(val => {
          var _fieldMetaData$values2;
          const option = (_fieldMetaData$values2 = fieldMetaData.values) === null || _fieldMetaData$values2 === void 0 ? void 0 : _fieldMetaData$values2.find(item => item.value.toString() === val.toString());
          return option ? option.label : val.toString();
        }).join(', ') : '';
      }
    case 'text':
    case 'textarea':
    default:
      return fieldValue !== null && fieldValue !== void 0 ? fieldValue : '';
  }
}
ResilientFieldsComponent.displayName = 'ResilientFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;