"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalFormField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/resilient/additional_form_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdditionalGenericField = /*#__PURE__*/_react.default.memo(({
  path,
  label,
  'data-test-subj': dataTestSubj,
  Component,
  field
}) => {
  const fieldProps = (0, _react.useMemo)(() => {
    return {
      config: {
        defaultValue: '',
        label
      },
      componentProps: {
        euiFieldProps: {
          display: 'center',
          'data-test-subj': dataTestSubj,
          required: field.required === 'always'
        }
      }
    };
  }, [label, dataTestSubj, field]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    config: fieldProps.config,
    component: Component,
    componentProps: fieldProps.componentProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  });
});
AdditionalGenericField.displayName = 'AdditionalGenericField';
const AdditionalDateField = /*#__PURE__*/_react.default.memo(({
  path,
  label,
  'data-test-subj': dataTestSubj,
  showTimeSelect,
  field
}) => {
  const fieldProps = (0, _react.useMemo)(() => {
    return {
      config: {
        label
      },
      defaultValue: (0, _moment.default)(),
      componentProps: {
        euiFieldProps: {
          'data-test-subj': dataTestSubj,
          showTimeSelect,
          required: field.required === 'always'
        }
      }
    };
  }, [label, dataTestSubj, showTimeSelect, field]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    config: fieldProps.config,
    defaultValue: fieldProps.defaultValue,
    component: _components.DatePickerField,
    componentProps: fieldProps.componentProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  });
});
AdditionalDateField.displayName = 'AdditionalDateField';
const AdditionalSelectField = /*#__PURE__*/_react.default.memo(({
  path,
  label,
  'data-test-subj': dataTestSubj,
  field
}) => {
  const fieldProps = (0, _react.useMemo)(() => {
    const calculatedOptions = (field.values || []).reduce((acc, val) => {
      acc.options.push({
        label: val.label,
        text: val.label,
        value: val.value
      });
      if (!acc.defaultValue && val.default) {
        acc.defaultValue = parseInt(val.value, 10);
      }
      return acc;
    }, {
      options: [],
      defaultValue: undefined
    });
    return {
      config: {
        label
      },
      componentProps: {
        euiFieldProps: {
          'data-test-subj': dataTestSubj,
          hasNoInitialSelection: true,
          disabled: false,
          isLoading: false,
          required: field.required === 'always',
          options: calculatedOptions.options
        }
      },
      defaultValue: calculatedOptions.defaultValue
    };
  }, [label, dataTestSubj, field]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    config: fieldProps.config,
    component: _components.SelectField,
    componentProps: fieldProps.componentProps,
    defaultValue: fieldProps.defaultValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  });
});
AdditionalSelectField.displayName = 'AdditionalSelectField';
const AdditionalMultiSelectInnerField = /*#__PURE__*/_react.default.memo(({
  field,
  label,
  outerField,
  options,
  'data-test-subj': dataTestSubj
}) => {
  const onChangeComboBox = (0, _react.useCallback)(changedOptions => {
    field.setValue(changedOptions.map(option => parseInt(option.value, 10)));
  }, [field]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return field.value.map(val => {
      var _outerField$values$fi, _outerField$values, _outerField$values$fi2;
      return {
        value: val.toString(),
        label: (_outerField$values$fi = (_outerField$values = outerField.values) === null || _outerField$values === void 0 ? void 0 : (_outerField$values$fi2 = _outerField$values.find(type => val.toString() === type.value.toString())) === null || _outerField$values$fi2 === void 0 ? void 0 : _outerField$values$fi2.label) !== null && _outerField$values$fi !== void 0 ? _outerField$values$fi : ''
      };
    });
  }, [field.value, outerField.values]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: false,
    "data-test-subj": dataTestSubj,
    isClearable: true,
    isDisabled: false,
    isLoading: false,
    onChange: onChangeComboBox,
    options: options,
    selectedOptions: selectedOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }));
});
AdditionalMultiSelectInnerField.displayName = 'AdditionalMultiSelectInnerField';
const AdditionalMultiSelectField = /*#__PURE__*/_react.default.memo(({
  path,
  label,
  'data-test-subj': dataTestSubj,
  field
}) => {
  const fieldProps = (0, _react.useMemo)(() => {
    const preparedOptions = (field.values || []).reduce((acc, value) => {
      acc.options.push({
        label: value.label,
        value: value.value.toString()
      });
      if (value.default === true) {
        acc.defaultValue.push(parseInt(value.value, 10));
      }
      return acc;
    }, {
      options: [],
      defaultValue: []
    });
    const componentProps = {
      label,
      outerField: field,
      options: preparedOptions.options,
      'data-test-subj': dataTestSubj
    };
    return {
      config: {
        defaultValue: []
      },
      componentProps,
      defaultValue: preparedOptions.defaultValue
    };
  }, [label, dataTestSubj, field]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    config: fieldProps.config,
    component: AdditionalMultiSelectInnerField,
    componentProps: fieldProps.componentProps,
    defaultValue: fieldProps.defaultValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  });
});
AdditionalMultiSelectField.displayName = 'AdditionalMultiSelectField';
const AdditionalFormField = exports.AdditionalFormField = /*#__PURE__*/_react.default.memo(({
  field
}) => {
  const path = field.name;
  const dataTestSubj = `resilientAdditionalField-${field.name}`;
  const props = (0, _react.useMemo)(() => {
    return {
      path,
      label: field.text,
      field,
      'data-test-subj': dataTestSubj
    };
  }, [path, field, dataTestSubj]);
  switch (field.input_type) {
    case 'text':
      return /*#__PURE__*/_react.default.createElement(AdditionalGenericField, (0, _extends2.default)({}, props, {
        Component: _components.TextField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 14
        }
      }));
    case 'textarea':
      return /*#__PURE__*/_react.default.createElement(AdditionalGenericField, (0, _extends2.default)({}, props, {
        Component: _components.TextAreaField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 14
        }
      }));
    case 'datetimepicker':
      return /*#__PURE__*/_react.default.createElement(AdditionalDateField, (0, _extends2.default)({}, props, {
        showTimeSelect: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 249,
          columnNumber: 14
        }
      }));
    case 'datepicker':
      return /*#__PURE__*/_react.default.createElement(AdditionalDateField, (0, _extends2.default)({}, props, {
        showTimeSelect: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 14
        }
      }));
    case 'boolean':
      return /*#__PURE__*/_react.default.createElement(AdditionalGenericField, (0, _extends2.default)({}, props, {
        Component: _components.CheckBoxField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 14
        }
      }));
    case 'number':
      return /*#__PURE__*/_react.default.createElement(AdditionalGenericField, (0, _extends2.default)({}, props, {
        Component: _components.NumericField,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 14
        }
      }));
    case 'select':
      return /*#__PURE__*/_react.default.createElement(AdditionalSelectField, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 14
        }
      }));
    case 'multiselect':
      return /*#__PURE__*/_react.default.createElement(AdditionalMultiSelectField, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 14
        }
      }));
  }
  return null;
});
AdditionalFormField.displayName = 'AdditionalFormField';