"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  NO_CASES: true,
  NO_CASES_BODY: true,
  NO_CASES_BODY_READ_ONLY: true,
  SHOWING_SELECTED_CASES: true,
  SHOWING_CASES: true,
  MAX_CASES: true,
  SHOW_ALL_CASES: true,
  LAST_30_DAYS: true,
  CUSTOM_QUICK_SELECT_PANEL: true,
  DISMISS: true,
  NOT_SHOW_AGAIN: true,
  UNIT: true,
  SEARCH_CASES: true,
  BULK_ACTIONS: true,
  EXTERNAL_INCIDENT: true,
  SEVERITY: true,
  INCIDENT_MANAGEMENT_SYSTEM: true,
  SEARCH_PLACEHOLDER: true,
  CLOSED: true,
  SELECT: true,
  ALREADY_ATTACHED: true,
  REQUIRES_UPDATE: true,
  UP_TO_DATE: true,
  NOT_PUSHED: true,
  REFRESH: true,
  PUSH_LINK_ARIA: true,
  STATUS: true,
  CHANGE_STATUS: true,
  ATTC_STAT: true,
  ATTC_STAT_INFO_ARIA_LABEL: true,
  ATTC_DESCRIPTION: true,
  FILTER_ASSIGNEES_ARIA_LABEL: true,
  CLEAR_FILTERS: true,
  TOTAL_ASSIGNEES_FILTERED: true,
  NO_ASSIGNEES: true,
  MAX_SELECTED_FILTER: true,
  SHOW_LESS: true,
  SHOW_MORE: true,
  NO_ATTACHMENTS_ADDED: true,
  COLUMNS: true,
  SHOW_ALL: true,
  HIDE_ALL: true,
  SEARCH: true,
  SEARCH_COLUMNS: true,
  DRAG_HANDLE: true,
  EMPTY_FILTER_MESSAGE: true,
  OPTIONS: true,
  MORE_FILTERS_LABEL: true,
  STATUS_OPEN: true,
  STATUS_IN_PROGRESS: true,
  STATUS_CLOSED: true
};
exports.STATUS = exports.SHOW_MORE = exports.SHOW_LESS = exports.SHOW_ALL_CASES = exports.SHOW_ALL = exports.SHOWING_SELECTED_CASES = exports.SHOWING_CASES = exports.SEVERITY = exports.SELECT = exports.SEARCH_PLACEHOLDER = exports.SEARCH_COLUMNS = exports.SEARCH_CASES = exports.SEARCH = exports.REQUIRES_UPDATE = exports.REFRESH = exports.PUSH_LINK_ARIA = exports.OPTIONS = exports.NO_CASES_BODY_READ_ONLY = exports.NO_CASES_BODY = exports.NO_CASES = exports.NO_ATTACHMENTS_ADDED = exports.NO_ASSIGNEES = exports.NOT_SHOW_AGAIN = exports.NOT_PUSHED = exports.MORE_FILTERS_LABEL = exports.MAX_SELECTED_FILTER = exports.MAX_CASES = exports.LAST_30_DAYS = exports.INCIDENT_MANAGEMENT_SYSTEM = exports.HIDE_ALL = exports.FILTER_ASSIGNEES_ARIA_LABEL = exports.EXTERNAL_INCIDENT = exports.EMPTY_FILTER_MESSAGE = exports.DRAG_HANDLE = exports.DISMISS = exports.CUSTOM_QUICK_SELECT_PANEL = exports.COLUMNS = exports.CLOSED = exports.CLEAR_FILTERS = exports.CHANGE_STATUS = exports.BULK_ACTIONS = exports.ATTC_STAT_INFO_ARIA_LABEL = exports.ATTC_STAT = exports.ATTC_DESCRIPTION = exports.ALREADY_ATTACHED = void 0;
Object.defineProperty(exports, "STATUS_CLOSED", {
  enumerable: true,
  get: function () {
    return _translations3.CLOSED;
  }
});
Object.defineProperty(exports, "STATUS_IN_PROGRESS", {
  enumerable: true,
  get: function () {
    return _translations3.IN_PROGRESS;
  }
});
Object.defineProperty(exports, "STATUS_OPEN", {
  enumerable: true,
  get: function () {
    return _translations3.OPEN;
  }
});
exports.UP_TO_DATE = exports.UNIT = exports.TOTAL_ASSIGNEES_FILTERED = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
var _translations2 = require("../user_profiles/translations");
Object.keys(_translations2).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations2[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations2[key];
    }
  });
});
var _translations3 = require("@kbn/cases-components/src/status/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_CASES = exports.NO_CASES = _i18n.i18n.translate('xpack.cases.caseTable.noCases.title', {
  defaultMessage: 'No cases to display'
});
const NO_CASES_BODY = exports.NO_CASES_BODY = _i18n.i18n.translate('xpack.cases.caseTable.noCases.body', {
  defaultMessage: 'Create a case or edit your filters.'
});
const NO_CASES_BODY_READ_ONLY = exports.NO_CASES_BODY_READ_ONLY = _i18n.i18n.translate('xpack.cases.caseTable.noCases.readonly.body', {
  defaultMessage: 'Edit your filter settings.'
});
const SHOWING_SELECTED_CASES = totalRules => _i18n.i18n.translate('xpack.cases.caseTable.selectedCasesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Selected {totalRules} {totalRules, plural, =1 {case} other {cases}}'
});
exports.SHOWING_SELECTED_CASES = SHOWING_SELECTED_CASES;
const SHOWING_CASES = (totalRules, pageSize) => _i18n.i18n.translate('xpack.cases.caseTable.showingCasesTitle', {
  values: {
    totalRules,
    pageSize
  },
  defaultMessage: 'Showing {pageSize} of {totalRules} {totalRules, plural, =1 {case} other {cases}}'
});
exports.SHOWING_CASES = SHOWING_CASES;
const MAX_CASES = maxCases => _i18n.i18n.translate('xpack.cases.caseTable.maxCases', {
  values: {
    maxCases
  },
  defaultMessage: 'The results were capped at {maxCases} to maintain performance. Try limiting your search to reduce the results.'
});
exports.MAX_CASES = MAX_CASES;
const SHOW_ALL_CASES = exports.SHOW_ALL_CASES = _i18n.i18n.translate('xpack.cases.caseTable.showAllCases', {
  defaultMessage: 'Show all cases'
});
const LAST_30_DAYS = exports.LAST_30_DAYS = _i18n.i18n.translate('xpack.cases.caseTable.last30Days', {
  defaultMessage: 'Last 30 days'
});
const CUSTOM_QUICK_SELECT_PANEL = exports.CUSTOM_QUICK_SELECT_PANEL = _i18n.i18n.translate('xpack.cases.caseTable.customQuickSelect', {
  defaultMessage: 'Custom quick select'
});
const DISMISS = exports.DISMISS = _i18n.i18n.translate('xpack.cases.caseTable.dismiss', {
  defaultMessage: 'Dismiss'
});
const NOT_SHOW_AGAIN = exports.NOT_SHOW_AGAIN = _i18n.i18n.translate('xpack.cases.caseTable.notShowAgain', {
  defaultMessage: 'Do not show again'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.cases.caseTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {case} other {cases}}`
});
exports.UNIT = UNIT;
const SEARCH_CASES = exports.SEARCH_CASES = _i18n.i18n.translate('xpack.cases.caseTable.searchAriaLabel', {
  defaultMessage: 'Search cases'
});
const BULK_ACTIONS = exports.BULK_ACTIONS = _i18n.i18n.translate('xpack.cases.caseTable.bulkActions', {
  defaultMessage: 'Bulk actions'
});
const EXTERNAL_INCIDENT = exports.EXTERNAL_INCIDENT = _i18n.i18n.translate('xpack.cases.caseTable.snIncident', {
  defaultMessage: 'External incident'
});
const SEVERITY = exports.SEVERITY = _i18n.i18n.translate('xpack.cases.caseTable.severity', {
  defaultMessage: 'Severity'
});
const INCIDENT_MANAGEMENT_SYSTEM = exports.INCIDENT_MANAGEMENT_SYSTEM = _i18n.i18n.translate('xpack.cases.caseTable.incidentSystem', {
  defaultMessage: 'Incident management system'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseTable.searchPlaceholder', {
  defaultMessage: 'Search cases'
});
const CLOSED = exports.CLOSED = _i18n.i18n.translate('xpack.cases.caseTable.closed', {
  defaultMessage: 'Closed'
});
const SELECT = exports.SELECT = _i18n.i18n.translate('xpack.cases.caseTable.select', {
  defaultMessage: 'Select'
});
const ALREADY_ATTACHED = exports.ALREADY_ATTACHED = _i18n.i18n.translate('xpack.cases.caseTable.alreadyAttached', {
  defaultMessage: 'Added',
  description: 'In this context, "Added" is letting the user know that all of their selected alerts were previously added to the case in question, and the "Add to case" button is disabled'
});
const REQUIRES_UPDATE = exports.REQUIRES_UPDATE = _i18n.i18n.translate('xpack.cases.caseTable.requiresUpdate', {
  defaultMessage: ' requires update'
});
const UP_TO_DATE = exports.UP_TO_DATE = _i18n.i18n.translate('xpack.cases.caseTable.upToDate', {
  defaultMessage: ' is up to date'
});
const NOT_PUSHED = exports.NOT_PUSHED = _i18n.i18n.translate('xpack.cases.caseTable.notPushed', {
  defaultMessage: 'Not pushed'
});
const REFRESH = exports.REFRESH = _i18n.i18n.translate('xpack.cases.caseTable.refreshTitle', {
  defaultMessage: 'Refresh'
});
const PUSH_LINK_ARIA = thirdPartyName => _i18n.i18n.translate('xpack.cases.caseTable.pushLinkAria', {
  values: {
    thirdPartyName
  },
  defaultMessage: 'click to view the incident on { thirdPartyName }.'
});
exports.PUSH_LINK_ARIA = PUSH_LINK_ARIA;
const STATUS = exports.STATUS = _i18n.i18n.translate('xpack.cases.caseTable.status', {
  defaultMessage: 'Status'
});
const CHANGE_STATUS = exports.CHANGE_STATUS = _i18n.i18n.translate('xpack.cases.caseTable.changeStatus', {
  defaultMessage: 'Change status'
});
const ATTC_STAT = exports.ATTC_STAT = _i18n.i18n.translate('xpack.cases.casesStats.mttr', {
  defaultMessage: 'Average time to close'
});
const ATTC_STAT_INFO_ARIA_LABEL = exports.ATTC_STAT_INFO_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.casesStats.mttr.info.ariaLabel', {
  defaultMessage: 'More about average time to close'
});
const ATTC_DESCRIPTION = exports.ATTC_DESCRIPTION = _i18n.i18n.translate('xpack.cases.casesStats.mttrDescription', {
  defaultMessage: 'The average duration (from creation to closure) for your current cases'
});
const FILTER_ASSIGNEES_ARIA_LABEL = exports.FILTER_ASSIGNEES_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.allCasesView.filterAssigneesAriaLabel', {
  defaultMessage: 'click to filter assignees'
});
const CLEAR_FILTERS = exports.CLEAR_FILTERS = _i18n.i18n.translate('xpack.cases.allCasesView.clearFilters', {
  defaultMessage: 'Clear filters'
});
const TOTAL_ASSIGNEES_FILTERED = total => _i18n.i18n.translate('xpack.cases.allCasesView.totalFilteredUsers', {
  defaultMessage: '{total, plural, one {# filter} other {# filters}} selected',
  values: {
    total
  }
});
exports.TOTAL_ASSIGNEES_FILTERED = TOTAL_ASSIGNEES_FILTERED;
const NO_ASSIGNEES = exports.NO_ASSIGNEES = _i18n.i18n.translate('xpack.cases.allCasesView.filterAssignees.noAssigneesLabel', {
  defaultMessage: 'No assignees'
});
const MAX_SELECTED_FILTER = (count, field) => _i18n.i18n.translate('xpack.cases.userProfile.maxSelectedAssigneesFilter', {
  defaultMessage: "You've selected the maximum number of {count} {field}",
  values: {
    count,
    field
  }
});
exports.MAX_SELECTED_FILTER = MAX_SELECTED_FILTER;
const SHOW_LESS = exports.SHOW_LESS = _i18n.i18n.translate('xpack.cases.allCasesView.showLessAvatars', {
  defaultMessage: 'show less'
});
const SHOW_MORE = count => _i18n.i18n.translate('xpack.cases.allCasesView.showMoreAvatars', {
  defaultMessage: '+{count} more',
  values: {
    count
  }
});
exports.SHOW_MORE = SHOW_MORE;
const NO_ATTACHMENTS_ADDED = exports.NO_ATTACHMENTS_ADDED = _i18n.i18n.translate('xpack.cases.modal.attachments.noAttachmentsTitle', {
  defaultMessage: 'No attachments added to the case'
});
const COLUMNS = exports.COLUMNS = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelection', {
  defaultMessage: 'Columns'
});
const SHOW_ALL = exports.SHOW_ALL = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelectionShowAll', {
  defaultMessage: 'Show All'
});
const HIDE_ALL = exports.HIDE_ALL = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelectionHideAll', {
  defaultMessage: 'Hide All'
});
const SEARCH = exports.SEARCH = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelectionSearch', {
  defaultMessage: 'Search'
});
const SEARCH_COLUMNS = exports.SEARCH_COLUMNS = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelectionSearchColumns', {
  defaultMessage: 'Search Columns'
});
const DRAG_HANDLE = exports.DRAG_HANDLE = _i18n.i18n.translate('xpack.cases.allCasesView.columnSelectionDragHandle', {
  defaultMessage: 'Drag Handle'
});
const EMPTY_FILTER_MESSAGE = exports.EMPTY_FILTER_MESSAGE = _i18n.i18n.translate('xpack.cases.tableFilters.useFilters.emptyMessage', {
  defaultMessage: 'No options'
});
const OPTIONS = totalCount => _i18n.i18n.translate('xpack.cases.tableFilters.useFilters.options', {
  defaultMessage: '{totalCount, plural, one {# option} other {# options}}',
  values: {
    totalCount
  }
});
exports.OPTIONS = OPTIONS;
const MORE_FILTERS_LABEL = exports.MORE_FILTERS_LABEL = _i18n.i18n.translate('xpack.cases.tableFilters.moreFiltersLabel', {
  defaultMessage: 'More'
});