"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateRangeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_on_refresh_cases = require("./use_on_refresh_cases");
var _translations = require("./translations");
var _use_get_earliest_case = require("./use_get_earliest_case");
var _constants = require("../../containers/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/date_range_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DateRangeFilter = ({
  filterOptions,
  onFilterOptionsChange,
  isLoading,
  deselectCases
}) => {
  const refreshCases = (0, _use_on_refresh_cases.useRefreshCases)();
  const {
    earliestCase,
    isLoading: isLoadingEarliestCase
  } = (0, _use_get_earliest_case.useGetEarliestCase)(filterOptions);
  const onRefresh = (0, _react.useCallback)(() => {
    deselectCases();
    refreshCases();
  }, [deselectCases, refreshCases]);
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    onFilterOptionsChange({
      from: start,
      to: end
    });
  }, [onFilterOptionsChange]);
  const onShowAllCases = (0, _react.useCallback)(() => {
    var _earliestCase$created;
    const fromDate = (_earliestCase$created = earliestCase === null || earliestCase === void 0 ? void 0 : earliestCase.createdAt) !== null && _earliestCase$created !== void 0 ? _earliestCase$created : _constants.DEFAULT_FROM_DATE;
    onFilterOptionsChange({
      from: fromDate,
      to: 'now'
    });
  }, [onFilterOptionsChange, earliestCase]);
  const onLast30Days = (0, _react.useCallback)(() => {
    onFilterOptionsChange({
      from: 'now-30d',
      to: 'now'
    });
  }, [onFilterOptionsChange]);
  const customQuickSelectPanels = (0, _react.useMemo)(() => [{
    title: _translations.CUSTOM_QUICK_SELECT_PANEL,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onShowAllCases,
      "data-test-subj": "show-all-cases-link",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, _translations.SHOW_ALL_CASES)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onLast30Days,
      "data-test-subj": "last-30-days-link",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 15
      }
    }, _translations.LAST_30_DAYS)))
  }], [onShowAllCases, onLast30Days]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": "date-range-filter",
    isLoading: isLoading || isLoadingEarliestCase,
    start: filterOptions.from,
    end: filterOptions.to,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    updateButtonProps: {
      fill: false
    },
    customQuickSelectPanels: customQuickSelectPanels,
    width: "auto",
    showUpdateButton: 'iconOnly',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  });
};
exports.DateRangeFilter = DateRangeFilter;
DateRangeFilter.displayName = 'DateRangeFilter';