"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullscreenControlWithContext = exports.FullscreenControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRecompose = require("react-recompose");
var _transient = require("../../../state/actions/transient");
var _workpad = require("../../../state/selectors/workpad");
var _ui_metric = require("../../../lib/ui_metric");
var _constants = require("../../../../common/lib/constants");
var _transitions_registry = require("../../../lib/transitions_registry");
var _elements = require("../../../state/actions/elements");
var _workpad_routing_context = require("../../../routes/workpad/workpad_routing_context");
var _fullscreen_control = require("./fullscreen_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/fullscreen_control/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: a lot of this is borrowed code from `/components/workpad/index.js`.
// We should consider extracting the next/prev page logic into to a shared lib file.
const mapStateToProps = state => ({
  workpadId: (0, _workpad.getWorkpad)(state).id,
  pages: (0, _workpad.getPages)(state),
  selectedPageNumber: (0, _workpad.getSelectedPageIndex)(state) + 1
});
const mapDispatchToProps = dispatch => ({
  fetchAllRenderables: () => dispatch((0, _elements.fetchAllRenderables)())
});
const FullscreenControlWithContext = props => {
  const {
    isFullscreen,
    autoplayInterval,
    nextPage,
    previousPage,
    setFullscreen,
    setIsAutoplayPaused,
    isAutoplayPaused
  } = (0, _react.useContext)(_workpad_routing_context.WorkpadRoutingContext);
  const autoplayEnabled = autoplayInterval > 0 ? true : false;
  const dispatch = (0, _reactRedux.useDispatch)();
  const setFullscreenWithEffects = (0, _react.useCallback)(value => {
    value && dispatch((0, _transient.selectToplevelNodes)([]));
    setFullscreen(value);
    if (value === true) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.COUNT, autoplayEnabled ? [_constants.LAUNCHED_FULLSCREEN, _constants.LAUNCHED_FULLSCREEN_AUTOPLAY] : _constants.LAUNCHED_FULLSCREEN);
    }
  }, [dispatch, setFullscreen, autoplayEnabled]);
  const toggleAutoplay = (0, _react.useCallback)(() => {
    setIsAutoplayPaused(!isAutoplayPaused);
  }, [setIsAutoplayPaused, isAutoplayPaused]);
  return /*#__PURE__*/_react.default.createElement(_fullscreen_control.FullscreenControl, (0, _extends2.default)({
    isFullscreen: isFullscreen,
    nextPage: nextPage,
    previousPage: previousPage,
    autoplayEnabled: autoplayEnabled,
    setFullscreen: setFullscreenWithEffects,
    toggleAutoplay: toggleAutoplay
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }));
};
exports.FullscreenControlWithContext = FullscreenControlWithContext;
const FullscreenControl = exports.FullscreenControl = (0, _reactRecompose.compose)((0, _reactRecompose.getContext)({
  router: _propTypes.default.object
}), (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps), (0, _reactRecompose.withState)('transition', 'setTransition', null), (0, _reactRecompose.withState)('prevSelectedPageNumber', 'setPrevSelectedPageNumber', 0), (0, _reactRecompose.withProps)(({
  selectedPageNumber,
  prevSelectedPageNumber,
  transition
}) => {
  function getAnimation(pageNumber) {
    if (!transition || !transition.name) {
      return null;
    }
    if (![selectedPageNumber, prevSelectedPageNumber].includes(pageNumber)) {
      return null;
    }
    const {
      enter,
      exit
    } = _transitions_registry.transitionsRegistry.get(transition.name);
    const laterPageNumber = Math.max(selectedPageNumber, prevSelectedPageNumber);
    const name = pageNumber === laterPageNumber ? enter : exit;
    const direction = prevSelectedPageNumber > selectedPageNumber ? 'reverse' : 'normal';
    return {
      name,
      direction
    };
  }
  return {
    getAnimation
  };
}), (0, _reactRecompose.withHandlers)({
  onTransitionEnd: ({
    setTransition
  }) => () => setTransition(null)
}))(FullscreenControlWithContext);