"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadApp = exports.WORKPAD_CONTAINER_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../../i18n");
var _sidebar = require("../sidebar");
var _toolbar = require("../toolbar");
var _workpad = require("../workpad");
var _workpad_header = require("../workpad_header");
var _constants = require("../../../common/lib/constants");
var _doc_title = require("../../lib/doc_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_app/workpad_app.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WORKPAD_CONTAINER_ID = exports.WORKPAD_CONTAINER_ID = 'canvasWorkpadContainer';
const WorkpadApp = ({
  deselectElement,
  isWriteable,
  workpad
}) => {
  const interactivePageLayout = (0, _react.useRef)(null); // future versions may enable editing on multiple pages => use array then
  const workpadTitle = (0, _react.useRef)(null); // future versions may enable editing on multiple pages => use array then

  // TODO: Remove this focus when https://github.com/elastic/kibana/issues/38980 is addressed
  (0, _react.useEffect)(() => {
    var _workpadTitle$current;
    (_workpadTitle$current = workpadTitle.current) === null || _workpadTitle$current === void 0 ? void 0 : _workpadTitle$current.focus();
  }, [workpadTitle]);
  const registerLayout = (0, _react.useCallback)(newLayout => {
    if (interactivePageLayout.current !== newLayout) {
      interactivePageLayout.current = newLayout;
    }
  }, []);
  const unregisterLayout = (0, _react.useCallback)(oldLayout => {
    if (interactivePageLayout.current === oldLayout) {
      interactivePageLayout.current = null;
    }
  }, []);
  const commit = interactivePageLayout.current || (() => {});
  const untitledWorkpadLabel = (0, _react.useMemo)(() => (0, _doc_title.getUntitledWorkpadLabel)(), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__rows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__cols",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stageHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "canvasWorkpadTitle",
    className: "euiScreenReaderOnly",
    ref: workpadTitle,
    tabIndex: -1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, `${_i18n.CANVAS} - ${workpad.name || untitledWorkpadLabel}`), /*#__PURE__*/_react.default.createElement(_workpad_header.WorkpadHeader, {
    commit: commit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    id: _constants.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR,
    className: _constants.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: WORKPAD_CONTAINER_ID,
    className: "canvasWorkpadContainer canvasLayout__stageContentOverflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_workpad.Workpad, {
    registerLayout: registerLayout,
    unregisterLayout: unregisterLayout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  })))), isWriteable && /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__sidebar hide-for-sharing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    commit: commit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__footer hide-for-sharing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))));
};
exports.WorkpadApp = WorkpadApp;
WorkpadApp.propTypes = {
  isWriteable: _propTypes.default.bool.isRequired,
  deselectElement: _propTypes.default.func
};