"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _expression_form_handlers = require("../../../common/lib/expression_form_handlers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764936232885125656/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/arg_template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mergeWithFormHandlers = handlers => Object.assign(new _expression_form_handlers.ExpressionFormHandlers(), handlers);
const ArgTemplateFormComponent = ({
  template,
  argumentProps,
  handlers,
  error,
  errorTemplate
}) => {
  const [updatedHandlers, setHandlers] = (0, _react.useState)(mergeWithFormHandlers(handlers));
  const prevError = (0, _usePrevious.default)(error);
  const [argument, setArgument] = (0, _react.useState)();
  const mountedArgumentRef = (0, _react.useRef)();
  const domNodeRef = (0, _react.useRef)(null);
  (0, _useEffectOnce.default)(() => () => {
    mountedArgumentRef.current = undefined;
  });
  const onMount = (0, _react.useCallback)(ref => {
    if (!mountedArgumentRef.current && ref) {
      mountedArgumentRef.current = ref;
    }
  }, []);
  const renderTemplate = (0, _react.useCallback)(domNode => template && template(domNode, argumentProps, updatedHandlers, onMount), [argumentProps, onMount, template, updatedHandlers]);
  const renderErrorTemplate = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(errorTemplate, argumentProps), [errorTemplate, argumentProps]);
  (0, _react.useEffect)(() => {
    if (!argument && domNodeRef.current) {
      const arg = renderTemplate(domNodeRef.current);
      if (arg) {
        setArgument(arg);
      }
    }
  }, [argument, renderTemplate]);
  (0, _react.useEffect)(() => {
    setHandlers(mergeWithFormHandlers(handlers));
  }, [handlers]);
  (0, _react.useEffect)(() => {
    if (mountedArgumentRef.current) {
      var _mountedArgumentRef$c;
      (_mountedArgumentRef$c = mountedArgumentRef.current) === null || _mountedArgumentRef$c === void 0 ? void 0 : _mountedArgumentRef$c.updateProps(argumentProps);
    }
  }, [argumentProps]);
  (0, _react.useEffect)(() => {
    if (!prevError && error) {
      updatedHandlers.destroy();
    }
  }, [prevError, error, updatedHandlers]);
  if (error) {
    mountedArgumentRef.current = undefined;
    return renderErrorTemplate();
  }
  if (!template) {
    mountedArgumentRef.current = undefined;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "render_to_dom",
    ref: domNodeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, argument);
};
const ArgTemplateForm = exports.ArgTemplateForm = /*#__PURE__*/(0, _react.memo)(ArgTemplateFormComponent, (prevProps, nextProps) => (0, _reactFastCompare.default)(prevProps, nextProps));